﻿using System.ComponentModel.DataAnnotations;

namespace Siger.WeComApi.Core.Dto.Request
{
    public class RequestAddProject
    {
        /// <summary>
        /// 企业id
        /// </summary>
        [Required(ErrorMessage = "CompanyIdIsEmpty")]
        public string companyid { get; set; }
        /// <summary>
        /// 说明
        /// </summary>
        public string description { get; set; }
        /// <summary>
        /// 最终报价
        /// </summary>
        public string finaloffer { get; set; }
        /// <summary>
        /// 初始报价
        /// </summary>
        public string initialquotation { get; set; }
        /// <summary>
        /// 账号
        /// </summary>
        [Required(ErrorMessage = "MobileIsEmpty")]
        public string mobile { get; set; }
        /// <summary>
        /// 密码
        /// </summary>
        public string password { get; set; }

        /// <summary>
        /// 用户名
        /// </summary>
        [Required(ErrorMessage = "Username_NotNull")]
        public string realname { get; set; }
        /// <summary>
        /// 项目名称
        /// </summary>
        [Required(ErrorMessage = "TitleIsEmpty")]
        public string title { get; set; }
        /// <summary>
        /// 负责销售id
        /// </summary>
        [Required(ErrorMessage = "SalesIdIsEmpty")]
        public string salesmid { get; set; }
        /// <summary>
        /// 项目类型
        /// </summary>
        public string typeid { get; set; }

        public string is_password { get; set; }

        public int dutymid { get; set; }

        public string modular { get; set; }

        public string dashboard_ids { get; set; }

        public int pid { get; set; }

        public int default_email { get; set; }
        public string project_email { get; set; }
    }

    public class RequestUpdateProject : RequestAddProject
    {
        [Required(ErrorMessage = "IdIsEmpty")]
        public int id { get; set; }
    }
}
