﻿using System.Collections.Generic;
using Siger.WeComApi.Core.Domain.Data;
using Siger.WeComApi.Core.Domain.Entity;
using Siger.WeComApi.Core.Domain.Paged;
using Siger.WeComApi.Core.Dto.Response;

namespace Siger.WeComApi.Core.Repository
{
    public interface ISigerProjectRepository : IRepositoryBase<siger_project>
    {
        Project GetProject(int id);

        IPagedCollectionResult<Project> GetPagedCollectionResult(string title, string mid,
            string companyid, string dutymid, string salesmid, string typeid, int page, int pagesize, int companyType, int parentId);

        IEnumerable<ResponseIdTitle> GetAllDashboards();
        IEnumerable<ResponseGetAdminsForDorpdown> GetProjectUser(int type, int customerType, int parentCompany);

        IEnumerable<ResponseProjectInfo> GetProjectByName(string name, int companyId);
    }
}
