﻿using Newtonsoft.Json;
using Siger.BaseDataApi.Common;
using Siger.Middlelayer.MachineToolApi.Response;
using System.Collections.Generic;

namespace Siger.Middlelayer.IoTApi
{
    public class IoTHelper
    {
        private static IoTHelper instance = null;

        private static object singletion_lock = new object();

        private string Url { get; set; }

        private string get_postion_path { get; set; }

        private string Lock_path { get; set; }

        public static IoTHelper CreaeteInstance()
        {
            if (instance == null)
            {
                lock (singletion_lock)
                {
                    if (instance == null)
                    {
                        instance = new IoTHelper();
                    }
                }
            }
            return instance;
        }

        private IoTHelper()
        {
            Url = ConfigManager.GetValue("BoxSetting", "Url", string.Empty);
            get_postion_path = ConfigManager.GetValue("BoxSetting", "get_postion", string.Empty);
            Lock_path = ConfigManager.GetValue("BoxSetting", "Lock", string.Empty);
        }

        /// <summary>
        /// 获取设备的定位信息
        /// </summary>
        /// <param name="machineName">设备编号</param>
        public IoTResponse<IotPositionData> GetPosition(string machineName)
        {
            string getpostionUrl = $"{Url}{get_postion_path}";

            List<KeyValuePair<string, string>> paramArray = new List<KeyValuePair<string, string>>();
            paramArray.Add(new KeyValuePair<string, string>("machineName", machineName));
            //var res = HttpHelper.Get($"{getpostionUrl}", paramArray);
            string res = @"{
                            'ret': 0,
                            'msg': '',
                            'data': {
                                'time':'07:56:30',
                                'gcj02':{ //高德
                                'Lng':'120.43713972', //经度
                                'Lat':'31.16002512' //维度
                                },
                                'db09':{ //百度
                                'Lng':'120.43713972', //经度
                                'Lat':'31.16002512' //维度
                                }
                            }
                        }";
            var result = (IoTResponse<IotPositionData>)JsonConvert.DeserializeObject(res, typeof(IoTResponse<IotPositionData>));
            return result;
        }

        /// <summary>
        /// 设备锁机开机
        /// </summary>
        /// <param name="machineName"></param>
        /// <param name="address"></param>
        /// <param name="isLock"></param>
        /// <returns></returns>
        public IoTResponse<object> MachineLock(string machineName, string address, string isLock)
        {
            string getpostionUrl = $"{Url}{Lock_path}";
            List<KeyValuePair<string, string>> paramArray = new List<KeyValuePair<string, string>>();
            paramArray.Add(new KeyValuePair<string, string>("machineName", machineName));
            paramArray.Add(new KeyValuePair<string, string>("address", address));
            paramArray.Add(new KeyValuePair<string, string>("isLock", isLock));
            //var res = HttpHelper.Get($"{getpostionUrl}", paramArray);
            string res = @"{
                            'ret': 0,
                            'msg': ''
                           }";
            var result = (IoTResponse<object>)JsonConvert.DeserializeObject(res, typeof(IoTResponse<object>));
            return result;
        }
    }
}