﻿
using System.Collections.Generic;

namespace Siger.WeComApi.Common.ExcelImport
{
    public class InspectStandardMaterialLevelTemplate : ImportBase
    {
        [ExcelColumn("物料编号*")]
        public string materialpn { get; set; }

        [ExcelColumn("物料名称")]
        [DonnetCreate]
        [DonnetValidate]
        public string materialname { get; set; }

        [ExcelColumn("项次*")]
        public int seq { get; set; }

        [ExcelColumn("检验项目类别*")]
        public string category { get; set; }

        [ExcelColumn("检验项目*")]
        public string item { get; set; }

        [ExcelColumn("检验标准*")]
        public string standard { get; set; }

        [ExcelColumn("维护方式*(打钩=>1,填值=>2)")]
        public string value_type { get; set; }

        [ExcelColumn("值类型*(单值=>1,最大值最小值=>2)")]
        public string value_category { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("最小值")]
        public string min_value { get; set; }

        [ExcelColumn("最大值")]
        public string max_value { get; set; }

        [ExcelColumn("极差")]
        public string range { get; set; }

        [ExcelColumn("缺陷类型*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_category { get; set; }

        [ExcelColumn("缺陷名称*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_name { get; set; }

        [ExcelColumn("缺陷代码*")]
        public string unhealthy_code { get; set; }

        [ExcelColumn("维护人")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_mid { get; set; }

        [ExcelColumn("维护时间")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_time { get; set; }
    }

    public class InspectionStandardMaterialLevelTemplate : InspectStandardMaterialLevelTemplate
    {
        [ExcelColumn("产线结构")]
        public List<string> sections { get; set; } = new List<string>();
    }

    public class InspectionStandardMaterials : InspectionStandardMaterialLevelTemplate
    {
        public int materialid { get; set; }

        public int sectionid { get; set; }

        public int unhealthyid { get; set; }

        public string unhealthyname { get; set; }

        public int categoryid { get; set; }
    }

    public class InspectionStandardMaterialTemplate : ImportBase
    {
        [ExcelColumn("物料编号*")]
        public string materialpn { get; set; }

        [ExcelColumn("物料名称")]
        [DonnetCreate]
        [DonnetValidate]
        public string materialname { get; set; }

        [ExcelColumn("物料规格")]
        [DonnetCreate]
        [DonnetValidate]
        public string materialspec { get; set; }

        [ExcelColumn("检验位置*")]
        public string section { get; set; }

        [ExcelColumn("项次*")]
        public int seq { get; set; }

        [ExcelColumn("是否送检")]
        public string isinpect { get; set; }

        [ExcelColumn("检验类型*")]
        public string inpectcategories { get; set; }

        [ExcelColumn("检验项目类别*")]
        public string category { get; set; }

        [ExcelColumn("检验项目*")]
        public string item { get; set; }

        [ExcelColumn("检验标准*")]
        public string standard { get; set; }

        [ExcelColumn("维护方式*(打钩=>1,填值=>2)")]
        public string value_type { get; set; }

        [ExcelColumn("值类型*(单值=>1,最大值最小值=>2)")]
        public string value_category { get; set; }

        [ExcelColumn("单位")]
        public string unit { get; set; }

        [ExcelColumn("最小值")]
        public string min_value { get; set; }

        [ExcelColumn("最大值")]
        public string max_value { get; set; }

        [ExcelColumn("极差")]
        public string range { get; set; }

        [ExcelColumn("缺陷类型*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_category { get; set; }

        [ExcelColumn("缺陷名称*")]
        [DonnetCreate]
        [DonnetValidate]
        public string unhealthy_name { get; set; }

        [ExcelColumn("缺陷代码*")]
        public string unhealthy_code { get; set; }

        [ExcelColumn("维护人")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_mid { get; set; }

        [ExcelColumn("维护时间")]
        [DonnetCreate]
        [DonnetValidate]
        public string update_time { get; set; }
    }

    public class InspectionStandardMaterialList : InspectionStandardMaterialTemplate
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        [DonnetValidate]
        public int No { get; set; }
    }
}
