﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using Siger.WeComApi.Common.CommonModels;
using Siger.WeComApi.Common.Enums;
using Siger.WeComApi.Common.Exceptions;
using Siger.WeComApi.Common.Extensions;
using Siger.WeComApi.Common.Logger;
using System.Net;

namespace Siger.WeComApi.Common.Filter
{
    public class ApiExceptionFilter : IExceptionFilter
    {
        public void OnException(ExceptionContext context)
        {
            if (context.Exception is BadRequestException badRequestException)
            {
                context.HttpContext.Response.StatusCode = (int)HttpStatusCode.OK;
                context.Result = new ObjectResult(new ResponseBase(0, badRequestException.ExceptionEnum.ToInt32(), badRequestException.Message));
            }
            else if (context.Exception is ServerException serverException)
            {
                context.HttpContext.Response.StatusCode = (int)HttpStatusCode.OK;
                context.Result = new ObjectResult(new ResponseBase(0, serverException.msg, serverException.Message));
            }
            else if (context.Exception is ClientException clientException)
            {
                context.HttpContext.Response.StatusCode = (int)HttpStatusCode.OK;
                context.Result = new ObjectResult(new ResponseBase(0, 0, clientException.msg));
            }
            else if (context.Exception is CommonException commonException)
            {
                context.HttpContext.Response.StatusCode = (int)HttpStatusCode.OK;
                context.Result = new ObjectResult(new ResponseBase(0, CommonEnum.Fail.ToInt32(), commonException.msg));
            }
            else
            {
                context.HttpContext.Response.StatusCode = (int)HttpStatusCode.InternalServerError;
                context.Result = new ObjectResult(new ResponseBase(0, CommonEnum.SystemExcetion.ToInt32(), context.Exception.Message));
                SigerLogger.Error(context.Exception);
            }
            context.ExceptionHandled = true;
        }
    }
}
