﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Domain.BigData.Models
{
    public class BeatSetInfo
    {
        public int id { get; set; }

        /// <summary>
        /// 产线id
        /// </summary>
        public int section_id { get; set; }

        /// <summary>
        /// 设备id
        /// </summary>
        public int machineID { get; set; }

        /// <summary>
        /// pId
        /// </summary>
        public int projectID { get; set; }

        /// <summary>
        /// 加工程序号
        /// </summary>
        public string process_number { get; set; }

        /// <summary>
        /// 产品名称 编号
        /// </summary>
        public string product_name { get; set; }

        /// <summary>
        /// 产品图纸号
        /// </summary>
        public string drawing_number { get; set; }

        /// <summary>
        /// 标准节拍(单位/ 秒 S )
        /// </summary>
        public int standard_besat { get; set; }

        /// <summary>
        /// 日标准产量(单位/pcs个)
        /// </summary>
        public int daily_standard_output { get; set; }

        /// <summary>
        /// 添加时间
        /// </summary>
        public DateTime add_time { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime? edit_time { get; set; }

        /// <summary>
        /// 产品名称
        /// </summary>
        public string product_name_text { get; set; }

        /// <summary>
        /// 换型时间
        /// </summary>
        public int changemodeltime { get; set; }

        /// <summary>
        /// 工序顺序
        /// </summary>
        public string route_number { get; set; } = "";

        /// <summary>
        /// 工序名称
        /// </summary>
        public string route_name { get; set; }

        /// <summary>
        /// 上下料时间
        /// </summary>
        public double updown_besat { get; set; }

        /// <summary>
        /// 产量比率
        /// </summary>
        public int yieldrate { get; set; }

        /// <summary>
        /// 有效开始时间
        /// </summary>
        public DateTime start_time { get; set; }

        /// <summary>
        /// 有效结束时间
        /// </summary>
        public DateTime end_time { get; set; }

        public int status { get; set; }
    }
}
