﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Domain.BigData.Models
{
    public class MachineState
    {
        public double FeedRatio { get; set; } = 0;

        public double FeedSpeed { get; set; } = 0;

        public int MachineId { get; set; }

        public int section_id { get; set; }

        public string PN { get; set; } = string.Empty;

        public string SPN { get; set; } = string.Empty;

        public double SpindleLoad1 { get; set; } = 0;

        public double SpindleLoad2 { get; set; } = 0;

        public double SpindleLoad3 { get; set; } = 0;

        public double SpindleLoad4 { get; set; } = 0;

        public double SpindleSpeed1 { get; set; } = 0;

        public double SpindleSpeed2 { get; set; } = 0;

        public double SpindleSpeed3 { get; set; } = 0;

        public double SpindleSpeed4 { get; set; } = 0;

        public double SpindleRatio { get; set; } = 0;

        public int Staus { get; set; } = 0;

        public string machineTitle { get; set; } = string.Empty;

        public string title { get; set; } = string.Empty;

        public double HoldTime { get; set; }

        public int x { get; set; }

        public int y { get; set; }

        public int lastSecondSectionId { get; set; }
        public List<MachineStatusSummarys> machinestatus { get; set; }

        public string dataTime { get; set; }

        public string FactoryName { get; set; }

        public int FactoryId { get; set; }

        /// <summary>
		/// 父级设备类型
		/// </summary>
        public string ParentMachinetype { get; set; }
        /// <summary>
        /// 设备类型
        /// </summary>
        public string MachineType { get; set; }
        /// <summary>
        /// 机床序列号
        /// </summary>
        public string MachineSerialnum { get; set; }
        /// <summary>
        /// 盒子编号
        /// </summary>
        public string BoxNumber { get; set; }
        /// <summary>
        /// 控制系统型号
        /// </summary>
        public string ControllerModel { get; set; }

        /// <summary>
        /// 设备创建时期
        /// </summary>
        public DateTime MachineTime { get; set; }

        /// <summary>
		/// 设备联网时间
		/// </summary>
        public DateTime? NetworkTime { get; set; }

        /// <summary>
        /// 开机
        /// </summary>
        public double po { get; set; } = 0;

        /// <summary>
        /// 操作
        /// </summary>
        public double opt { get; set; } = 0;

        /// <summary>
        /// 切削
        /// </summary>
        public double cut { get; set; } = 0;

        /// <summary>
        /// 循环
        /// </summary>
        public double ct { get; set; } = 0;

        /// <summary>
        /// x轴温度
        /// </summary>
        public double xtv { get; set; } = 0;

        /// <summary>
        /// y轴温度
        /// </summary>

        public double ytv { get; set; } = 0;

        /// <summary>
        /// y轴温度
        /// </summary>

        public double ztv { get; set; } = 0;

    }
    public class MachineStatusSummarys
    {
        public int status { get; set; }

        public double time { get; set; }

        public string percent { get; set; }
    }
    public class RequestSectionList
    {
        public List<MachineState> listmst { get; set; }

        public List<int> sectionIds { get; set; }
    }

    public class MachineIdList
    {
        public int MachineId { get; set; }

        public int section_id { get; set; }
    }
}
