﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Siger.WeComApi.Core.Dto.Request
{
    public class RequestCompanyRegister
    {
        public RegisterCompany company { get; set; }
        public RegisterProject project { get; set; }
        public List<RegisterProjectLevel> levels { get; set; }
        public RegisterLicence licence { get; set; }
    }

    public class RegisterCompany
    {
        /// <summary>
        /// CID ,如果值为0 为 新注册公司
        /// </summary>
        public int cid { get; set; }
        [Required(ErrorMessage = "nameIsEmpty")]
        public string name { get; set; }
        public string nameEn { get; set; }
        [Required(ErrorMessage = "provinceIsEmpty")]
        public string province { get; set; }
        public string city { get; set; }
        public string area { get; set; }
        [Required(ErrorMessage = "addressIsEmpty")]
        public string address { get; set; }
        [Required(ErrorMessage = "ContactIsEmpty")]
        public string contacts { get; set; }
        [Required(ErrorMessage = "phoneIsEmpty")]
        public string phone { get; set; }
        public string email { get; set; }
        public string companycode { get; set; }
        public string industrycategory { get; set; }
        public string industrysecond { get; set; }
        public string logoimg { get; set; }
    }

    public class RegisterProject
    {
        public string title { get; set; }
        public int typeid { get; set; }
        public int salesmid { get; set; }
        public string realname { get; set; }
        public string account { get; set; }
        public string password { get; set; }
        public int initialoffer { get; set; }
        public int finaloffer { get; set; }
        public string description { get; set; }
    }
    public class RegisterProjectLevel
    {
        public int id { get; set; }
        public string title { get; set; }
    }
    public class RegisterLicence
    {
        /// <summary>
        /// 1.永久 2.时间配置 
        /// </summary>
        public int type { get; set; }
        /// <summary>
        /// license 值 2时间配置时存在
        /// </summary>
        public string values { get; set; }
        /// <summary>
        /// 项目库 mysql 配置
        /// </summary>
        public string mysql { get; set; }
    }

}
