﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using Microsoft.Extensions.Primitives;
using Siger.WeComApi.Common.CommonModels;
using Siger.WeComApi.Common.Constants;
using Siger.WeComApi.Common.Enums;
using Siger.WeComApi.Common.Exceptions;
using Siger.WeComApi.Common.Extensions;
using Siger.WeComApi.Common.Helpers;
using System.Linq;
using System.Net;

namespace Siger.WeComApi.Common.Filter
{
    /// <summary>
    /// 结果fiel
    /// </summary>
    public class ResultFilter : ActionFilterAttribute
    {
        public override void OnActionExecuted(ActionExecutedContext context)
        {
            context.HttpContext.Request.Headers.TryGetValue(ParameterConstant.Token, out StringValues value);

            if (!SkipResult(context))
            {
                var status = context.HttpContext.Response.StatusCode;
                if (status != (int)HttpStatusCode.OK)
                {
                    var error = context.Exception.InnerException != null ? context.Exception.InnerException.Message : context.Exception.Message;
                    context.Result = new ObjectResult(new ResponseBase(0, CommonEnum.SystemExcetion.ToInt32(), error));
                    return;
                }

                var origialResult = context.Result;
                switch (origialResult)
                {
                    case null:
                        if (context.Exception is BadRequestException badRequestException)
                        {
                            context.Result = new ObjectResult(new ResponseBase(0, badRequestException.ExceptionEnum.ToInt32(), null));
                        }
                        else if (context.Exception is ServerException serverException)
                        {
                            context.Result = new ObjectResult(new ResponseBase(0, serverException.msg, null));
                        }
                        else if (context.Exception is ClientException clintException)
                        {
                            context.Result = new ObjectResult(new ResponseBase(0, 0, clintException.msg));
                        }
                        else
                        {
                            context.Result = new ObjectResult(new ResponseBase(0, CommonEnum.SystemExcetion.ToInt32(), context.Exception.Message));
                        }
                        return;
                    case ObjectResult objectResult:
                        context.Result = new JsonResult(objectResult.Value);
                        break;
                }
            }
            base.OnActionExecuted(context);
            //Reset time && API成功计数设置
            _ = TokenHelper.Instance.ResetToken(value);
        }

        /// <summary>
        /// 判断控制器和Action是否要进行拦截
        /// </summary>
        /// <param name="actionContext"></param>
        /// <returns></returns>
        private static bool SkipResult(ActionExecutedContext actionContext)
        {
            return actionContext.ActionDescriptor.FilterDescriptors.Any(q => q.Filter.GetType() == typeof(NoResultFilter));
        }
    }
}
