﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Domain.BigData.Models
{
    public class EfficiencyInfo
    {
        /// <summary>
        /// 平均稼动率
        /// </summary>
        public string operatingrate { get; set; }
        public double runningtime { get; set; } = 0;
        public double freetime { get; set; } = 0;
        public double commissioningtime { get; set; } = 0;

        public double alarmtime { get; set; } = 0;
        public double shutdowntime { get; set; } = 0;
    }

    /// <summary>
    /// 稼动率明细，统计
    /// </summary>
    public class EfficiencyDetailInfo : EfficiencyInfo
    {
        public double restTime { get; set; } = 0;

        public double totalTime { get; set; } = 0;
    }

    /// <summary>
    /// 请求参数
    /// </summary>
    public class EfficiencyParam
    {
        public DateTime dtStart { get; set; }

        public DateTime dtEnd { get; set; }

        public int frequency { get; set; }

        public List<int> machineIds { get; set; }

        public int pid { get; set; }

        public int cid { get; set; }

    }
}
