﻿using Siger.WeComApi.Core.Enum.ModuleEnum;
using System.ComponentModel.DataAnnotations;

namespace Siger.WeComApi.Core.Dto.Request
{
    public class RequestAddBusiness
    {
        /// <summary>
        /// 项目类型id
        /// </summary>
        [Required(ErrorMessage = "TypeIDNotNull")]
        public int typeNameID { get; set; }
        /// <summary>
        /// 项目名称
        /// </summary>
        [Required(ErrorMessage = "BusinessNameNotNull")]
        public string name { get; set; }
        /// <summary>
        /// 企业名称
        /// </summary>
        [Required(ErrorMessage = "CompanyNameNotNull")]
        public string enterprise_name { get; set; }
        /// <summary>
        /// 地址
        /// </summary>
        [Required(ErrorMessage = "AddressNotNull")]
        public string address { get; set; }
        /// <summary>
        /// 联系人
        /// </summary>
        [Required(ErrorMessage = "ContractNotNull")]
        public string linkman { get; set; }
        /// <summary>
        /// 联系电话
        /// </summary>
        [Required(ErrorMessage = "PhoneNotNull")]
        public string phone { get; set; }
        /// <summary>
        /// 账号
        /// </summary>
        [Required(ErrorMessage = "MobileNotNull")]
        public string mobile { get; set; } = string.Empty;
        /// <summary>
        /// 
        /// </summary>
        public string fax { get; set; } = string.Empty;
        public string email { get; set; } = string.Empty;
        public string homepage { get; set; } = string.Empty;
        public string description { get; set; } = string.Empty;

        /// <summary>
        /// 是否停用
        /// </summary>
        public bool statu { get; set; } = false;

        [Required(ErrorMessage = "BusinessTypeNotNull")]
        public WMSEnum type { get; set; } = WMSEnum.Business;

        public string serial_number { get; set; } = string.Empty;

        public string duns { get; set; } = string.Empty;
    }

    public class RequestDelBusiness
    {
        [Required(ErrorMessage = "IDNotNull")]
        public int id { get; set; }
    }
    public class RequestUpdateBusiness : RequestAddBusiness
    {
        [Required(ErrorMessage = "IDNotNull")]
        public int id { get; set; }
    }
}
