﻿using Siger.WeComApi.Core.Enum.ModuleEnum;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace Siger.WeComApi.Core.Dto.Response
{
    public class ResponseProductReport
    {
        public int id { get; set; }
        /// <summary>
        /// 开始时间
        /// </summary>
        public DateTime start_time { get; set; }

        /// <summary>
        /// 结束时间
        /// </summary>
        public DateTime end_time { get; set; }


        /// <summary>
        /// 报工时间
        /// </summary>
        public DateTime time { get; set; }


        /// <summary>
        /// 生产执行人工号
        /// </summary>
        public string worker_code { get; set; }

        /// <summary>
        /// 生产执行人姓名
        /// </summary>
        public string worker_name { get; set; }

        /// <summary>
        /// 图纸号
        /// </summary>
        public string draw_number { get; set; }

        /// <summary>
        /// 产品名称
        /// </summary>
        public string product_name { get; set; }
        public string product_code { get; set; }
        public int station { get; set; }
        public string station_value { get; set; }
        public string process { get; set; }
        public int status { get; set; }
        public int okcount { get; set; }
        /// <summary>
        /// 工废
        /// </summary>
        public int industrial_waste { get; set; }
        /// <summary>
        /// 料废
        /// </summary>
        public int material_waste { get; set; }
        /// <summary>
        /// 总产量
        /// </summary>
        public int output { get; set; }
        /// <summary>
        /// 工令单
        /// </summary>
        public string code { get; set; }
        /// <summary>
        /// 工艺id
        /// </summary>
        public int processId { get; set; }
        public int uid { get; set; }
        public string processType { get; set; }
    }

    public class ResponseGetProducesReport
    {
        public int id { get; set; }

        public int plan_id { get; set; }

        public int machineid { get; set; }

        public string code { get; set; }

        public string produced_program_number { get; set; } = string.Empty;

        public int start_time { get; set; }

        public int end_time { get; set; }

        public int actual_output { get; set; }

        public int output { get; set; }

        public int time { get; set; }

        public int nok_number { get; set; }

        public string worker_code { get; set; }

        public string worker_name { get; set; }

        public string draw_number { get; set; } = string.Empty;

        public string product_name { get; set; }

        public string product_code { get; set; }

        public int section_id { get; set; }

        public string start_end_time { get; set; }

        public string title { get; set; } = "";

        public string daytime { get; set; } = "";

        public List<ResponseIdName> users { get; set; }

        public string orderNumber { get; set; } = "";

        public string program_number { get; set; } = "";

        public string machineLocation { get; set; } = "";

        public int approval_status { get; set; }

        public int approval_usermid { get; set; } = 0;

        public string approval_username { get; set; } = "";

        public string approval_datetime { get; set; } = "";

        public string route_name { get; set; }

        public int plan_type { get; set; }
        public int station { get; set; }
        public int processid { get; set; }
        public int uid { get; set; }

        public int industrial_waste { get; set; }
        public int material_waste { get; set; }
        public int approval_time { get; set; }

        public double rest_minutes { get; set; }
        public ResponseGetProducesReport()
        {
            users = new List<ResponseIdName>();
        }
    }

    public class ResponseGetProducesReportTwo
    {
        public int id { get; set; }
        public int planDetailid { get; set; }
        public int plan_id { get; set; }

        public int machineid { get; set; }

        public string code { get; set; }

        public string produced_program_number { get; set; } = string.Empty;

        public int start_time { get; set; }

        public int end_time { get; set; }

        public int actual_output { get; set; }

        public int output { get; set; }

        public int time { get; set; }

        public int nok_number { get; set; }

        public string worker_code { get; set; }

        public string worker_name { get; set; }

        public string draw_number { get; set; } = string.Empty;

        public string product_name { get; set; }

        public string product_code { get; set; }

        public int section_id { get; set; }

        public string start_end_time { get; set; }

        public string title { get; set; } = "";

        public string daytime { get; set; } = "";

        public List<ResponseIdName> users { get; set; }

        public string orderNumber { get; set; } = "";

        public string program_number { get; set; } = "";

        public string machineLocation { get; set; } = "";

        public int approval_status { get; set; }

        public int approval_usermid { get; set; } = 0;

        public string approval_username { get; set; } = "";

        public string approval_datetime { get; set; } = "";

        public string route_name { get; set; }

        public int plan_type { get; set; }
        public int station { get; set; }
        public int processid { get; set; }
        public int uid { get; set; }

        public int industrial_waste { get; set; }
        public int material_waste { get; set; }
        public int approval_time { get; set; }

        public double rest_minutes { get; set; }
        /// <summary>
        /// 工序ID
        /// </summary>
        public int routeid { get; set; }
        /// <summary>
        /// 工序号
        /// </summary>
        public int route { get; set; }
        /// <summary>
        /// 工序条码
        /// </summary>
        public string route_code { get; set; }
        /// <summary>
        /// 规格型号
        /// </summary>
        public string spec { get; set; }
        /// <summary>
        /// 额定工时
        /// </summary>
        public double ratedHours { get; set; }
        /// <summary>
        /// 泡沫工时
        /// </summary>
        public double foamHours { get; set; }
        /// <summary>
        /// 首道工序标记
        /// </summary>
        public int first { get; set; }
        /// <summary>
        /// 老图号
        /// </summary>
        public string order_category { get; set; }
        /// <summary>
        /// 订单号
        /// </summary>
        public string order { get; set; }
        public ResponseGetProducesReportTwo()
        {
            users = new List<ResponseIdName>();
        }
    }

    /// <summary>
    /// 查询人员报工信息回参
    /// </summary>
    public class ResponseUserReport
    {
        public int oksum { get; set; }
        public int noksum { get; set; }
        public List<ResponseUserReportDetails> data { set; get; }
    }
    public class ResponseUserReportDetails
    {
        /// <summary>
        /// 产品名称
        /// </summary>
        public string product_name { get; set; }
        /// <summary>
        /// 工序名称
        /// </summary>
        public string route_name { get; set; }
        /// <summary>
        /// 合格数
        /// </summary>
        public int ok_number { get; set; }
        /// <summary>
        /// 不合格数
        /// </summary>
        public int nok_number { get; set; }
        /// <summary>
        /// 报工时间
        /// </summary>
        public string report_time { get; set; }
    }
    /// <summary>
    /// 
    /// </summary>
    public class ResponsePlanReportDetails
    {
        public int plan_id { get; set; }
        public int plandDts_id { get; set; }

        /// <summary>
        /// 工令单
        /// </summary>
        public string code { get; set; }
        /// <summary>
        /// 产品名称
        /// </summary>
        public string product_name { get; set; }
        public int route_id { get; set; }
        /// <summary>
        /// 工序名称
        /// </summary>
        public string route_name { get; set; }
        /// <summary>
        /// 工序顺序
        /// </summary>
        public int route_serinum { get; set; }
        /// <summary>
        /// 合格数
        /// </summary>
        public int ok_number { get; set; }
        /// <summary>
        /// 不合格数
        /// </summary>
        public int nok_number { get; set; }
        /// <summary>
        /// 报工时间
        /// </summary>
        public string report_time { get; set; }
        /// <summary>
        /// 订单数量
        /// </summary>
        public int order_cnt { get; set; }
        /// <summary>
        /// 工单数量（装机数量）
        /// </summary>
        public int order_installCnt { get; set; }
        /// <summary>
        /// 工令单数量
        /// </summary>
        public int quantity { get; set; }
        /// <summary>
        /// 工令单状态
        /// </summary>
        public int status { get; set; }
    }

    public class ResponseGetRework
    {
        public int id { get; set; }
        public int planDetailid { get; set; }
        public int plan_id { get; set; }

        public int machineid { get; set; }

        public string code { get; set; }

        public string produced_program_number { get; set; } = string.Empty;

        public int start_time { get; set; }

        public int end_time { get; set; }

        public int actual_output { get; set; }

        public int output { get; set; }

        public int time { get; set; }

        public int nok_number { get; set; }

        public string worker_code { get; set; }

        public string worker_name { get; set; }

        public string draw_number { get; set; } = string.Empty;

        public string product_name { get; set; }

        public string product_code { get; set; }

        public int section_id { get; set; }

        public string start_end_time { get; set; }

        public string title { get; set; } = "";

        public string daytime { get; set; } = "";

        public List<ResponseIdName> users { get; set; }

        public string orderNumber { get; set; } = "";

        public string program_number { get; set; } = "";

        public string machineLocation { get; set; } = "";

        public int approval_status { get; set; }

        public int approval_usermid { get; set; } = 0;

        public string approval_username { get; set; } = "";

        public string approval_datetime { get; set; } = "";

        public string route_name { get; set; }

        public int plan_type { get; set; }
        public int station { get; set; }
        public int processid { get; set; }
        public int uid { get; set; }

        public int industrial_waste { get; set; }
        public int material_waste { get; set; }
        public int approval_time { get; set; }

        public double rest_minutes { get; set; }
        /// <summary>
        /// 工序号
        /// </summary>
        public int route { get; set; }
        /// <summary>
        /// 工序条码
        /// </summary>
        public string route_code { get; set; }
        /// <summary>
        /// 规格型号
        /// </summary>
        public string spec { get; set; }
        /// <summary>
        /// 额定工时
        /// </summary>
        public double ratedHours { get; set; }
        /// <summary>
        /// 泡沫工时
        /// </summary>
        public double foamHours { get; set; }
        /// <summary>
        /// 状态
        /// </summary>
        public int state { get; set; }
        /// <summary>
        /// 处理单号
        /// </summary>
        public string rework_code { get; set; }
        /// <summary>
        /// 责任人
        /// </summary>
        public string userid { get; set; }
        /// <summary>
        /// 1:返工 2：报废
        /// </summary>
        public int type { get; set; }
        /// <summary>
        /// 不良数量
        /// </summary>
        public int bad_number { get; set; }
        /// <summary>
        /// 不良原因
        /// </summary>
        public string bad_reason { get; set; }
        /// <summary>
        /// 检查人
        /// </summary>
        public string checkMid { get; set; }
        /// <summary>
        /// 检查时间
        /// </summary>
        public string checkTime { get; set; }
        /// <summary>
        /// 老图号
        /// </summary>
        public string order_category { get; set; }

        /// <summary>
        /// reworkid
        /// </summary>
        public int reworkid { get; set; }

        /// <summary>
        /// 订单号
        /// </summary>
        public string order { get; set; }
        public ResponseGetRework()
        {
            users = new List<ResponseIdName>();
        }
    }
    public class ResponseReworkScrapList
    {
        public List<int> ids { get; set; }
        public int bad_number { get; set; }
        public int ok_number { get; set; }
        public int actual_output { get; set; }
        public List<ResponseReworkScrap> ResponseReworkScrap { get; set; }
    }

    public class ResponseReworkScrap
    {
        public int planDetailid { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public int roportid { get; set; }
        /// <summary>
        /// 0:返工 1：报废
        /// </summary>
        public int type { get; set; }
        /// <summary>
        /// 不良数量
        /// </summary>
        public int bad_number { get; set; }
        /// <summary>
        /// 不良原因
        /// </summary>
        public string bad_reason { get; set; }
        /// <summary>
        /// 工序id
        /// </summary>
        public int route_id { get; set; }
        /// <summary>
        /// 工序条码
        /// </summary>
        public string route_code { get; set; }


    }


    public class ResponseGetRoute
    {
        /// <summary>
        /// 工序号
        /// </summary>
        public int route_id { get; set; }
        /// <summary>
        /// 工序名称
        /// </summary>
        public string route_name { get; set; }
    }

    public class SynchronizationReport
    {
        /// <summary>
        /// 工序码
        /// </summary>
        public string BarCode { get; set; }
        /// <summary>
        /// 质检类型(完工检,二次完工检)
        /// </summary>
        public string CheckType { get; set; }
        /// <summary>
        /// 操作员工号
        /// </summary>
        public string OptNo { get; set; }
        /// <summary>
        /// 操作员姓名
        /// </summary>
        public string OptName { get; set; }
        /// <summary>
        /// 质检员工号
        /// </summary>
        public string CheckerNo { get; set; }
        /// <summary>
        /// 质检员姓名
        /// </summary>
        public string CheckerName { get; set; }
        /// <summary>
        /// 首检合格数量,可为0
        /// </summary>
        public int FirstCheckOkQty { get; set; }
        /// <summary>
        /// 拒绝数量
        /// </summary>
        public int RejectQty { get; set; }
        /// <summary>
        /// 返工数量
        /// </summary>
        public int ReDoQty { get; set; }
        /// <summary>
        /// 重用数量
        /// </summary>
        public int ReUseQty { get; set; }
        /// <summary>
        /// 缺件数量
        /// </summary>
        public int ShortageQty { get; set; }
        /// <summary>
        /// 工废数量
        /// </summary>
        public int WorkBadQty { get; set; }
        /// <summary>
        /// 料废数量
        /// </summary>
        public int MaterialBadQty { get; set; }
        /// <summary>
        /// 检验日期时间
        /// </summary>
        public DateTime CheckDateTime { get; set; }
        /// <summary>
        /// 资源编码
        /// </summary>
        public string ResCode { get; set; }
    }

    /// <summary>
    /// 获取设备相关的订单信息
    /// </summary>
    public class ResponseGetMachineOrderInfo
    {
        /// <summary>
        /// 订单编号
        /// </summary>
        public string orderNumber { get; set; }

        /// <summary>
        /// 产品名称
        /// </summary>
        public string product_name { get; set; }

        /// <summary>
        /// 工序名称
        /// </summary>
        public string routename { get; set; }

        /// <summary>
        /// 进度id
        /// </summary>
        public int machineId { get; set; }

        /// <summary>
        /// 工序id
        /// </summary>

        public int route_id { get; set; }

        /// <summary>
        /// 计划id
        /// </summary>
        public int planId { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public int quantity { get; set; }
    }

    /// <summary>
    /// 工令单详情
    /// </summary>
    public class ResponseGetPlanDetailInfo
    {
        public int plan_id { get; set; }
        public int plandDts_id { get; set; }

        /// <summary>
        /// 工令单
        /// </summary>
        public string code { get; set; }
        /// <summary>
        /// 产品名称
        /// </summary>
        public string product_name { get; set; }
        public int route_id { get; set; }
        /// <summary>
        /// 工序名称
        /// </summary>
        public string route_name { get; set; }
        /// <summary>
        /// 工序顺序
        /// </summary>
        public int route_serinum { get; set; }
        /// <summary>
        /// 合格数
        /// </summary>
        public int ok_number { get; set; }
        /// <summary>
        /// 不合格数
        /// </summary>
        public int nok_number { get; set; }
        /// <summary>
        /// 报工时间
        /// </summary>
        public string report_time { get; set; }
        /// <summary>
        /// 订单数量
        /// </summary>
        public int order_cnt { get; set; }
        /// <summary>
        /// 工单数量（装机数量）
        /// </summary>
        public int order_installCnt { get; set; }
        /// <summary>
        /// 工令单数量
        /// </summary>
        public int quantity { get; set; }
        /// <summary>
        /// 工令单状态
        /// </summary>
        public int status { get; set; }

        /// <summary>
        /// 交付时间
        /// </summary>
        public string delivery_time { get; set; }

        /// <summary>
        /// 工令单号
        /// </summary>
        public string orderNumber { get; set; }

    }

}
