﻿namespace Siger.WeComApi.Common.CommonModels
{
    /// <summary>
    /// 分页请求响应基类
    /// </summary>
    /// <typeparam name="T"></typeparam>
    public class PageResponseBase<T> : ResponseBase<T> where T : class
    {
        /// <summary>
        /// 总条数
        /// </summary>
        public long Total { get; set; }

        /// <summary>
        /// 当前页
        /// </summary>
        public int Page { get; set; }

        /// <summary>
        /// 每页数据条数
        /// </summary>
        public int Pagesize { get; set; }

        /// <summary>
        /// 分页请求响应基类
        /// </summary>
        /// <param name="returnValue"></param>
        /// <param name="message"></param>
        /// <param name="dataobj"></param>
        /// <param name="totalValue"></param>
        /// <param name="pageValue"></param>
        /// <param name="pagesizeValue"></param>
        public PageResponseBase(int returnValue, int message, T dataobj, long totalValue, int pageValue, int pagesizeValue)
               : base(returnValue, message, dataobj)
        {
            Total = totalValue;
            Page = pageValue;
            Pagesize = pagesizeValue;
        }

        /// <summary>
        /// 分页请求响应基类
        /// </summary>
        /// <param name="dataobj"></param>
        /// <param name="totalValue"></param>
        /// <param name="pageValue"></param>
        /// <param name="pagesizeValue"></param>
        public PageResponseBase(T dataobj, long totalValue, int pageValue, int pagesizeValue)
               : base(dataobj)
        {
            Total = totalValue;
            Page = pageValue;
            Pagesize = pagesizeValue;
        }
    }
}
