﻿using Siger.WeComApi.Common.cache;
using System;
using System.Collections.Generic;
using System.IO;
using System.Security.Cryptography;
using System.Text;

namespace Siger.WeComApi.Common.Helpers
{
    public class LicenseHelper
    {

        private const string EncryptKey = "Sg#li018";
        private static readonly byte[] Keys = { 0x12, 0x78, 0x56, 0x31, 0x6F, 0x6A, 0x25, 0x7A };

        /// <summary>
        /// 生成加密License
        /// </summary>
        /// <param name="comanyId"></param>
        /// <param name="projectId"></param>
        /// <param name="startTime"></param>
        /// <param name="endTime"></param>
        /// <param name="machineCount"></param>
        /// <param name="userCount"></param>
        /// <returns></returns>
        public static string GenrateLicense(int comanyId, int projectId, string startTime, string endTime, int machineCount = 999999, int userCount = 999999)
        {
            var sb = new StringBuilder(1000);
            sb.Append("c|");
            sb.Append(comanyId);
            sb.Append("#p|");
            sb.Append(projectId);
            sb.Append("#m|");
            sb.Append(machineCount);
            sb.Append("#u|");
            sb.Append(userCount);
            sb.Append("#t|");
            sb.Append(DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
            sb.Append("#start|");
            sb.Append(DateTime.Parse(startTime).ToString("yyyy-MM-dd HH:mm:ss"));
            sb.Append("#end|");
            sb.Append(DateTime.Parse(endTime).AddDays(1).AddMilliseconds(-1).ToString("yyyy-MM-dd HH:mm:ss"));
            var unEncryptStr = sb.ToString();
            var encryptStr = Encrypt(unEncryptStr);
            return encryptStr == unEncryptStr ? string.Empty : encryptStr;
        }

        /// <summary>
        /// 加密
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>s
        public static string Encrypt(string value)
        {
            if (string.IsNullOrEmpty(value)) return string.Empty;
            try
            {
                byte[] rgbKey = Encoding.UTF8.GetBytes(EncryptKey);
                byte[] rgbIv = Keys;
                byte[] inputByteArray = Encoding.UTF8.GetBytes(value);
                var dCsp = new DESCryptoServiceProvider();
                using (var stream = new MemoryStream())
                {
                    using (var cStream = new CryptoStream(stream, dCsp.CreateEncryptor(rgbKey, rgbIv), CryptoStreamMode.Write))
                    {
                        cStream.Write(inputByteArray, 0, inputByteArray.Length);
                        cStream.FlushFinalBlock();
                        var output = Convert.ToBase64String(stream.ToArray());
                        return output;
                    }
                }
            }
            catch
            {
                return value;
            }
        }

        /// <summary>
        /// 解密
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public static string Decrypt(string value)
        {
            if (string.IsNullOrEmpty(value)) return string.Empty;
            try
            {
                byte[] rgbKey = Encoding.UTF8.GetBytes(EncryptKey);
                byte[] rgbIv = Keys;
                byte[] inputByteArray = Convert.FromBase64String(value);
                var dcsp = new DESCryptoServiceProvider();
                using (var stream = new MemoryStream())
                {
                    using (var cStream = new CryptoStream(stream, dcsp.CreateDecryptor(rgbKey, rgbIv), CryptoStreamMode.Write))
                    {
                        cStream.Write(inputByteArray, 0, inputByteArray.Length);
                        cStream.FlushFinalBlock();
                        return Encoding.UTF8.GetString(stream.ToArray());
                    }
                }
            }
            catch
            {
                return value;
            }
        }
    }
}
