﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Dto.Request
{
    public class RequestAddChannelMachine
    {
        /// <summary>
        /// 父级设备类型id
        /// </summary>
        public int ParentMachineType { get; set; }

        /// <summary>
        /// 设备类型id
        /// </summary>
        public int MachineType { get; set; }

        /// <summary>
        /// 机床序列号
        /// </summary>
        public string MachineToolSerialNumber { get; set; }

        /// <summary>
        /// 盒子编号
        /// </summary>
        public string BoxCode { get; set; }

        /// <summary>
        /// 控制系统型号
        /// </summary>
        public string ControllerModel { get; set; }

        /// <summary>
        /// 工厂名称(实际为pid)
        /// </summary>
        public int FactoryName { get; set; } = 0;

        /// <summary>
        /// 父级cid
        /// </summary>
        public int ParentCompanyId { get; set; }
        
        /// <summary>
        /// 父级pid
        /// </summary>
        public int ParentProjectId { get; set; }

        public int Creator { get; set; }

    }

    public class RequestUpdateChannelMachine: RequestAddChannelMachine
    {
        public int id { get; set; }
    }

    public class RequestQueryMachineToolMachine
    {
        /// <summary>
        /// 机床序列号
        /// </summary>
        public string MachineToolSerialNumber { get; set; }

        /// <summary>
        /// 盒子编号
        /// </summary>
        public string BoxCode { get; set; }

        /// <summary>
        /// 控制系统型号
        /// </summary>
        public string ControllerModel { get; set; }

        /// <summary>
        /// 工厂名称
        /// </summary>
        public string FactoryName { get; set; }

        /// <summary>
        /// 是否联网 1未联网 2已联网
        /// </summary>
        public int IsNetWork { get; set; }
        /// <summary>
        /// 父企业id
        /// </summary>
        public int ParentCompanyId { get; set; }
        /// <summary>
        /// 第几页
        /// </summary>
        public int Page { get; set; }
        /// <summary>
        /// 一页多少跳数据
        /// </summary>
        public int PageSize { get; set; }

        /// <summary>
        /// 工厂id
        /// </summary>
        public int FactoryId { get; set; }
        /// <summary>
        /// 是否锁机 0：已锁机 1：未锁机
        /// </summary>
        public int islock { get; set; }
        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }
    }
}
