﻿using System.ComponentModel.DataAnnotations;

namespace Siger.WeComApi.Core.Dto.Request
{
    public class RequestAddMaterials
    {
        [Required(ErrorMessage = "分类不能为空")]
        public int typeid { get; set; }

        [Required(ErrorMessage = "NameNotNull")]
        public string name { get; set; }

        [Required(ErrorMessage = "规格不能为空")]
        public string spec { get; set; }

        public string pn { get; set; }

        //[Required(ErrorMessage = "供应商不能为空")]
        public string supplier { get; set; }

        [Required(ErrorMessage = "管理模式不能为空")]
        public string manage_mode { get; set; }

        [Required(ErrorMessage = "计量单位不能为空")]
        public string unit { get; set; }

        //[Required(ErrorMessage = "换算单位不能为空")]
        public string conv_unit { get; set; }

        //[Required(ErrorMessage = "换算比例不能为空")]
        public string conv_proportion { get; set; }

        public double price { get; set; }

        public double min_stock { get; set; }

        public double max_stock { get; set; }

        public string is_disable { get; set; }

        public string is_first { get; set; }

        //[Required(ErrorMessage = "先入先出级别不能为空")]
        public string priority { get; set; }

        public double exp { get; set; }

        public string desc { get; set; }

        public string image { get; set; }

        public int category { get; set; }

        public int product_id { get; set; } = 0;
    }

    public class RequestUpdateMaterials : RequestAddMaterials
    {
        [Required(ErrorMessage = "IdIsEmpty")]
        public int id { get; set; }
    }
}
