﻿using Siger.WeComApi.Common;
using Siger.WeComApi.Common.Enums;
using Siger.WeComApi.Common.Enums.Extensions;
using Siger.WeComApi.Common.Exceptions;
using Siger.WeComApi.Core.Biz;
using Siger.WeComApi.Core.Repository;
using Siger.WeComApi.Core.Vos.Response;
using Siger.Middlelayer.Redis;
using Siger.Middlelayer.Redis.RedisEntities;
using System.Threading.Tasks;

namespace Siger.WeComApi.Biz.service
{
    public class DbNameConfigService : IDbNameConfigService
    {
        private readonly ISigerProjectRepository _projectRepository;
        public DbNameConfigService(ISigerProjectRepository projectRepository)
        {
            this._projectRepository = projectRepository;
        }

        public ResponseSaasDNC GetSaasDbNameConfig()
        {
            string BoxUrl = ConfigManager.GetValue("BoxSetting", "Url", string.Empty);

            string RedisHost = ConfigManager.GetValue("DbClusterSetting", "RedisHost", string.Empty);

            string DNCHost = "";
            string DNCPort = "";
            if (!string.IsNullOrEmpty(BoxUrl))
            {
                string[] urls = BoxUrl.Split(':');
                if (urls.Length > 0)
                {
                    DNCHost = urls[0];
                }

                if (urls.Length > 1)
                {
                    DNCPort = urls[1];
                }
            }

            var saasDNC = new ResponseSaasDNC();
            saasDNC.Redisdb= RedisHost;
            saasDNC.DNCHost = DNCHost;
            saasDNC.DNCPort = DNCPort;

            return saasDNC;
        }

        public async Task<ResponseDNC> GetConfig(int projectId)
        {
            var responseDNC = new ResponseDNC();
            var DbConfig = GetSaasDbNameConfig();

            var project = this._projectRepository.Get(q => q.id == projectId && q.status == (int)RowState.Valid);
            if (project == null)
            {
                throw new BadRequestException(RequestEnum.ProjectNotFound);
            }

            var result = await RedisCache.Instance.GetDbName(project.companyid.ToInt(), project.id);
            if (result != null)
            {
                if (DbConfig != null)
                {
                    if (result.SCService == DbConfig.DNCHost)
                    {
                        responseDNC.IsSaas = 1;
                        responseDNC.Redisdb = result.RedisDbName;
                        responseDNC.DNCHost = result.SCService;
                        responseDNC.DNCPort = result.SCPort;
                    }
                    else
                    {
                        responseDNC.IsSaas = 0;
                        responseDNC.Redisdb = result.RedisDbName;
                        responseDNC.DNCHost = result.SCService;
                        responseDNC.DNCPort = result.SCPort;
                    }
                }
            }
            return responseDNC;
        }
    }
}
