﻿using Microsoft.Extensions.DependencyInjection;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;

namespace Siger.WeComApi.Common
{
    public static class BatchInjectExtension
    {
        private static string namespaceStart = "Siger";

        private static List<string> assemblies = new List<string> {
          "Siger.WeComApi.Biz.dll",
          "Siger.WeComApi.Repository.dll",
        };
        private static List<string> endWiths = new List<string> {
          "Service",
          "Repository",
          "Factory",
          "UnitOfWork",
        };

        private static List<string> diBaseType = new List<string>
        {

        };
        public static void RegisterService(this IServiceCollection services)
        {
            var basePath = GetBasePath();
            foreach (var item in assemblies)
            {
                RegisterAssembly(basePath, item, services);
            }
        }

        private static string GetBasePath()
        {
            var rootPath = Path.GetDirectoryName(typeof(BatchInjectExtension).Assembly.Location); var rootDir = new DirectoryInfo(rootPath);
            return rootDir.FullName;
        }

        /// <summary>
        /// 注册指定程序集中的服务
        /// </summary>
        /// <param name="assemblyNames">程序集名的字典</param>
        /// <param name="services">IServiceCollection类型的对象</param>
        private static void RegisterAssembly(string basePath, string assemblyFile, IServiceCollection services)
        {
            string assemblyPath = Path.Combine(basePath, assemblyFile);
            var assembly = Assembly.LoadFrom(assemblyPath);
            List<Type> ts = assembly.GetTypes().ToList();
            var implementationClass = ts.Where(s => !s.IsInterface && !s.IsAbstract && CheckStartsWith(s.FullName));
            foreach (var item in implementationClass)
            {
                var interfaceTypes = item.GetInterfaces();
                var interfaceType = interfaceTypes.FirstOrDefault(x => CheckStartsWith(x.FullName));
                if (interfaceType != null)
                {
                    services.AddScoped(interfaceType, item);
                }
            }
        }


        private static bool CheckStartsWith(string source)
        {
            return source.StartsWith(namespaceStart, StringComparison.OrdinalIgnoreCase)
                && endWiths.Exists(x => source.EndsWith(x, StringComparison.OrdinalIgnoreCase));
        }
    }
}
