﻿using System;
using System.Linq;
using System.Text;
using OfficeOpenXml;
using OfficeOpenXml.Drawing.Chart;

namespace Siger.WeComApi.Common.Helpers
{
    public class EpPlusEchartHelper
    {
        private readonly ExcelWorksheet _worksheet1;
        private readonly ExcelWorksheet _worksheet2;
        private int _rowCount;
        public EpPlusEchartHelper(ExcelWorksheet worksheet1, ExcelWorksheet worksheet2, int rowCount)
        {
            _worksheet1 = worksheet1;
            _worksheet2 = worksheet2;
            _rowCount = rowCount;
        }

        //OEE 柱形图
        public void CreateOeeChart()
        {
            ExcelChart chart = _worksheet1.Drawings.AddChart("chart", eChartType.ColumnStacked);
            ExcelChartSerie serie = chart.Series.Add(_worksheet2.Cells[2, 3, _rowCount, 3], _worksheet2.Cells[2, 2, _rowCount, 2]);
            serie.HeaderAddress = _worksheet2.Cells[1, 3];
            chart.SetPosition(50, 10);
            chart.Title.Text = "OEE";
            chart.Title.Font.Size = 15;
            chart.Title.Font.Bold = true;
            chart.Style = eChartStyle.Style15;
        }

        //OEE 多条簇状柱形图
        public void CreateOeeDetailChart()
        {
            ExcelChartSerie serie = null;
            ExcelChart chart = _worksheet1.Drawings.AddChart("chart", eChartType.ColumnClustered);
            for (var i = 2; i <= _rowCount + 1; i++)
            {
                var x = _worksheet2.Cells[i, 2].Value.ToString();
                var y = string.Empty;
                for (var j = 3; j <= 6; j++)
                {
                    y += _worksheet2.Cells[i, j].Value + ",";
                }
                serie = chart.Series.Add(y.TrimEnd(','), x);
                serie.HeaderAddress = _worksheet2.Cells[1, 6];
            }
            
            chart.SetPosition(50, 10);
            chart.Title.Text = "OEE";
            chart.Title.Font.Size = 15;
            chart.Title.Font.Bold = true;
            chart.Style = eChartStyle.Style15;
        }

        //切片 百分比堆积柱状图
        public void CreateSliceChart()
        {
            ExcelChartSerie serie = null;
            ExcelChart chart = _worksheet1.Drawings.AddChart("chart", eChartType.ColumnStacked100);
            var cells = $"B1:{ToAlphaString(_worksheet2.Dimension.End.Column)}1";
            ExcelRangeBase rowRange = _worksheet2.Cells[cells]; //X
            for (int i = _worksheet2.Dimension.Start.Row; i < _worksheet2.Dimension.End.Row + 1; i++)
            {
                if (i > 1)
                {
                    ExcelRangeBase yRange = _worksheet2.Cells[i, 2, i, _worksheet2.Dimension.End.Column]; //X
                    serie = chart.Series.Add(yRange, rowRange); //设置Y轴，X轴
                    serie.HeaderAddress = _worksheet2.Cells[i, 1];//设置图表的图例
                }
            }

            chart.SetPosition(50, 10);
            chart.Title.Text = "设备切片分析";
            chart.Title.Font.Size = 15;
            chart.Title.Font.Bold = true;
            chart.Style = eChartStyle.Style10;
        }

        public void CreateEfficiencyAnalysis()
        {
            ExcelChart chart = _worksheet1.Drawings.AddChart("chart", eChartType.ColumnStacked);
            ExcelChartSerie serie = chart.Series.Add(_worksheet2.Cells[2, 2, _rowCount, 2], _worksheet2.Cells[2, 1, _rowCount, 1]);
            serie.HeaderAddress = _worksheet2.Cells[1, 3];
            chart.SetPosition(50, 10);
            chart.Title.Text = "时间稼动率";
            chart.Title.Font.Size = 15;
            chart.Title.Font.Bold = true;
            chart.Style = eChartStyle.Style15;
        }

        private static string ToAlphaString(int value)
        {
            var dividend = value;
            var columnName = string.Empty;

            while (dividend > 0)
            {
                var modulo = (dividend - 1) % 26;
                columnName = Convert.ToChar(65 + modulo) + columnName;
                dividend = (dividend - modulo) / 26;
            }

            return columnName;
        }
    }
}
