﻿using Siger.WeComApi.Core.Dto.Request;
using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Dto.Response
{
    public class ResponseRouteInfoByProduct
    {
        public List<ResponseRouteInfos> Routes { get; set; } = new List<ResponseRouteInfos>();

        public List<ResponseRouteValue> Versions { get; set; } = new List<ResponseRouteValue>();

        /// <summary>
        /// 默认版本
        /// </summary>
        public string DefaultVersion { get; set; }

        /// <summary>
        /// 版本数量
        /// </summary>
        public int VersionCount { get; set; }
    }

    public class ResponseRouteInfos
    {
        public List<RouteInfo> Routes { get; set; } = new List<RouteInfo>();
    }

    public class ResponseRouteVersionInfo
    {
        public int id { get; set; }
        /// <summary>
        /// 工艺版本
        /// </summary>
        public string Version { get; set; }

        public double VersionValue { get; set; }

        /// <summary>
        /// 工序数
        /// </summary>
        public int RouteCount { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public string Creator { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public string Create_Time { get; set; }

        /// <summary>
        /// 是否禁用 1是 2否
        /// </summary>
        public int IsDisable { get; set; }

        /// <summary>
        /// 是否默认 1是2否
        /// </summary>
        public int IsDefault { get; set; }
    }

    public class ResponseProductRoute
    {
        /// <summary>
        /// 默认版本
        /// </summary>
        public string DefaultVersion { get; set; }

        public List<ResponseRouteDetail> versionDetail = new List<ResponseRouteDetail>();
    }

    public class ResponseRouteDetail
    {
        /// <summary>
        /// 版本号
        /// </summary>
        public double VersionValue { get; set; }

        /// <summary>
        /// 版本号Desc
        /// </summary>
        public string Version { get; set; }
    }

    public class ResponseRouteValue
    {
        public string Version { get; set; }

        public string VersionValue { get; set; }
    }
}
