﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;

namespace Siger.WeComApi.Common.cache
{
    public class RunAsnc
    {
        public static List<T> GetListInfo<T>(string key, Func<List<T>> funcCallback, int asyncTime = 30)
        {
            var tuple = MemoryCache.IsContains(key);
            if (tuple.Item1)
            {
                if (tuple.Item2)
                {
                    //Task.Run(() =>
                    //{
                    var items = funcCallback.Invoke();
                    MemoryCache.UpdateCache(key, items, asyncTime);
                    //});
                }
                var itemStates = MemoryCache.GetValue<List<T>>(key);
                if (itemStates.Item1)
                {
                    //Logger.WriteLineInfo($"key：{key};数量{itemStates.Item2.Count}；");
                    return itemStates.Item2;
                }
                else
                {
                    return null;
                }
            }
            else
            {
                var items = funcCallback.Invoke();
                MemoryCache.AddCache(key, items, asyncTime);
                return items;
            }
        }

        public static bool RemoveKey(string key)
        {
            return MemoryCache.DelCache(key);
        }
    }

    public class MemoryCache
    {
        static ConcurrentDictionary<string, CacheObj> dictCache = new ConcurrentDictionary<string, CacheObj>();

        /// <summary>
        /// expire单位默认为分钟
        /// </summary>
        /// <param name="key"></param>
        /// <param name="val"></param>
        /// <param name="expire">超时时间</param>
        /// <returns></returns>
        public static bool AddCache(string key, object val, int expire = 20)
        {
            if (dictCache.ContainsKey(key))
            {
                return false;
            }
            else
            {
                var dt = DateTime.Now;
                var cacheObj = new CacheObj()
                {
                    Key = key,
                    Val = val,
                    CreateTime = dt,
                    ExpireTime = dt.AddMinutes(expire)
                };
                return dictCache.TryAdd(key, cacheObj);
            }
        }

        public static bool UpdateCache(string key, object val, int expire = 20)
        {
            if (dictCache.ContainsKey(key))
            {
                if (dictCache.TryGetValue(key, out CacheObj cacheObj))
                {
                    cacheObj.Val = val;
                    cacheObj.ExpireTime = DateTime.Now.AddMinutes(expire);
                    return true;
                }
            }
            return false;
        }

        public static bool DelCache(string key)
        {
            if (dictCache.ContainsKey(key))
            {
                if (dictCache.TryRemove(key, out CacheObj cache))
                {
                    return true;
                }
            }
            return false;
        }

        public static (bool, T) GetValue<T>(string key)
            where T : class
        {
            if (dictCache.ContainsKey(key))
            {
                if (dictCache.TryGetValue(key, out CacheObj cache))
                {
                    var obj = cache.Val as T;
                    return (true, obj);
                }
            }
            return (false, null);
        }

        public static (bool, bool) IsContains(string key)
        {
            if (dictCache.ContainsKey(key))
            {
                bool isExpire = false;
                if (dictCache.TryGetValue(key, out CacheObj cache))
                {
                    if (cache.ExpireTime < DateTime.Now)
                    {

                        isExpire = true;
                    }

                }

                return (true, isExpire);
            }
            return (false, false);
        }


    }


    public class CacheObj
    {
        public object Val { get; set; }

        public string Key { get; set; }

        public DateTime CreateTime { get; set; }

        public DateTime ExpireTime { get; set; }
    }
}
