﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;
namespace Siger.WeComApi.Core.Enum.ModuleEnum
{
    /// <summary>
    /// Cnc module, start from 4000000
    /// </summary>
    public enum CncEnum
    {
        //  启动模块--枚举
        [Description("CNC服务配置加载失败")] LoadCfgFail = 4000000,
        [Description("CNC服务注册Consul失败")] RegConsulFail,
        [Description("该产品和产线下已配置工序")] RouteHasExist,
        [Description("请至少添加一道工序")] RouteIsEmpty,
        [Description("工序不能重复")] RouteHasRepeat,
        [Description("该产品在该产线下尚未配置工序")] RoutesNotFound,
        [Description("该产品下仍有未配置标准节拍的设备")] MachineCycleTimeNotFound,
        [Description("生产计划未找到")] PlanNotFound,
        [Description("批次数必须大于0")] BatchMustGreaterZero,
        [Description("该生产计划已排产")] PlanHasExist,
        [Description("该生产计划不能终止")] PlanCannotStop,
        [Description("工令单不存在")] WorkOrderNotExist,
        [Description("时间格式不正确")] DateTimeFormatError,
        [Description("该状态下不能打印")] WorkOrderCannotPrint,
        [Description("此设备类型已设置异常时间")] TimeSettingHasExist,
        [Description("订单数量不能大于5000")] PlanQuanlityOverFlow,
        [Description("该工单未安排在该设备上生产")] PlanNotFoundOnMachine,
        [Description("设备编号不存在")] MachineIdNotExist,
        [Description("报工数量大于工令单数量")] MaxReportCount,
        [Description("报工前请先首检")] InspectionFirst,
        [Description("该数据已在审核，请勿重复操作！")] DataAlreadyExists,
        [Description("只有未报工数据，才可以作废！")] DataToVoid,
        [Description("只有未报工数据，才可以报工！")] DataToReport,
        [Description("只有已报工数据，才可以审核！")] DataToExamine,
        [Description("数据已完工或已终止，不可以派工！")] DataToDispatch,
        [Description("订单号不能为空")] OrderNumberNotNull,
        [Description("工单类型不能为空")] WorkOrderTypeNotNull,
        [Description("导入数据重复")] DataToSame,
        [Description("该生产计划已下发")] ProductionPlanIssued,
        [Description("没有要更新的数据")] PlanNoChangeData,
        [Description("该订单存在未审核的变更记录")] PlanHasUnApprovRecord,
        [Description("该设备已经签到")] MachineIsSignIn,
        [Description("客户名称不存在")] CustomerNameNotFound = 4000032,
        [Description("已下班签到，不可以报工！")] OffWorkToReport = 4000033,
        [Description("该工令单已被终止！")] PlanHasStop = 4000034,
        [Description("报工数量不能大于工令单数量")] ReportQuantityNotThanWOCount,
        [Description("该工序已经完工不能报工")] RouteisFinishedCanNotReport,
        [Description("上道工序未报工不能进行报工")] RouteCanNotReport,
        [Description("报工数量不能大于上道工序合格数量")] ReportCountCanNotThanLastRoute,
        [Description("工单数量不能小于已排数量，操作失败")] WorkOrderCountCanNotLessHasProductCount,
        [Description("订单数量不能小于工单数量，操作失败")] OrderCountCanNotLessWorkOrderCount,
        [Description("工艺版本不存在")] ProductRouteNotFound,
        [Description("工艺版本不能为空")] ProductRouteCanNotNull,
        [Description("该设备已经由该人员负责，请勿重复扫描")] MachineCanNotScanRepetition,
        [Description("上道工序未报工,不能开始调机")] LastRouteCanNotMachineRoute,
        [Description("资源组名称不能为空")] ResourceNameNotNull,
        [Description("资源效率不能为空")] ResourceEfficiencyNotNull,
        [Description("每日可用工时不能为空")] AvailableTimeNotNull,
        [Description("资源组名称已存在")] ResourceNameisExist,
        [Description("资源组未找到")] ResourceNotFound,
        [Description("排班时间不能大于该设备签到时间")] ClassTimeNotThanCheckTime,
        [Description("不良品号不能为空")]BadNumberNotNull,
        [Description("缺陷类型不能为空")] DefectTypeNotNull,
        [Description("缺陷原因不能为空")] FlawReasonNotNull,
        [Description("返工工序不能为空")]ReworkRouteNotNull,
        [Description("工单号不能为空")]WorkCodeNotNull,
        [Description("处理数量不能为空")]DisposeCountNotNull,
        [Description("处理数量不能大于NOK数量")]DisposeCountNotThanNOK,
        [Description("换型工时不能为空")] RemodelTimeNotNull,
        [Description("资源效率区间不能为空")] ResourcesIntervalNotNull,
        [Description("请选择时间")] PleaseSelectTime
    }

    /// <summary>
    /// 休息时间类型
    /// </summary>
    public enum ProductionTimeType
    {
        [Description("工作日")]
        WorkingDay = 1,

        [Description("节假日")]
        Holiday,

        [Description("周末")]
        Weekend
    }

    /// <summary>
    /// 计划变更，更改字段
    /// </summary>
    public enum PlanChange
    {
        [Description("订单号")]
        OrderNumber = 1,

        [Description("订单数量")]
        Quantity,

        [Description("工单数量")]
        InstallCount,

        [Description("交货期")]
        DeliveryTime,

        [Description("客户名称")]
        Customer,

        [Description("工艺版本")]
        Version,

        [Description("计划开始时间")]
        PlanStartTime,

        [Description("计划结束时间")]
        PlanEndTime,
        [Description("订单备注")]
        OrderRemark

    }

    /// <summary>
    /// 审核状态
    /// </summary>
    public enum AuditState
    {
        [Description("待审核")]
        WaitState = 1,

        [Description("已审核")]
        Reviewed,

        [Description("审核未通过")]
        AuditFailed,
    }

    /// <summary>
    /// 生产计划类型
    /// </summary>
    public enum PlanSource
    {
        [Description("手动添加")]
        Manual = 1,

        [Description("Excel导入")]
        ExcelImport,

        [Description("ERP对接")]
        ErpInterface
    }

    /// <summary>
    /// 生产计划状态
    /// </summary>
    public enum PlanProcess
    {
        [Description("未排产")]
        UnPlan,

        [Description("已排产")]
        HasPlan,

        [Description("生产中")]
        Producing,

        [Description("已完工")]
        Finished,

        [Description("已终止")]
        Stop,
    }
    /// <summary>
    /// 计划生产管理订单类型
    /// </summary>
    public enum PlanOrderType
    {
        [Description("成品")]
        HasProduct = 1,
        [Description("新品")]
        NewProduct,
        [Description("调试")]
        Debugging,
        [Description("返工")]
        Rework,
    }

    public enum PersonStation
    {
        [Description("工位")]
        Station = 1,
        [Description("人员")]
        Person,
    }

    public enum PlanStopState
    {
        [Description("待生产")]
        ToProduced = 1,
        [Description("生产中")]
        Producing,
    }

    /// <summary>
    /// 计划内派工
    /// </summary>
    public enum PlanDispatch
    {

        [Description("已删除")]
        IsDelete = 0,

        [Description("未下发")]
        UnIssue = 1,

        [Description("未排产")]
        UnPlan = 2,

        [Description("已派工")]
        HasPlan,

        [Description("生产中")]
        Producing,

        [Description("已完工")]
        Finished,

        [Description("已终止")]
        Stop,
        [Description("逾期")]
        Overdue,
        [Description("调机中")]
        Debugging,
        [Description("暂停中")]
        Suspend,
    }
    /// <summary>
    /// 计划外派工
    /// </summary>
    public enum PlanOutDispatch
    {
        [Description("未报工")]
        UnReport = 1,
        [Description("已报工")]
        HasReport,
        [Description("审核以通过")]
        Reviewed,
        [Description("审核未通过")]
        UnReviewed,
        [Description("已作废")]
        Voided,
    }
    /// <summary>
    /// 休息时间类型
    /// </summary>
    public enum TimeType
    {
        [Description("星期一")]
        Monday = 1,

        [Description("星期二")]
        Tuesday,

        [Description("星期三")]
        Wednesday,

        [Description("星期四")]
        Thursday,

        [Description("星期五")]
        Friday,

        [Description("星期六")]
        Saturday,

        [Description("星期日")]
        Sunday,

        [Description("节假日")]
        Holiday
    }

    public enum OrderReportApprovalStatus
    {
        [Description("待审核")]
        WaitingForApproval = 0,

        [Description("审核通过")]
        Pass = 1,

        [Description("审核不通过")]
        Deny = 2
    }
    /// <summary>
    /// wo type 票据追溯枚举
    /// </summary>
    public enum WoType
    {
        /// <summary>
        /// 首检
        /// </summary>
        [Description("报工")]
        Report = 0,
        /// <summary>
        /// 首检
        /// </summary>
        [Description("首检")]
        First = 1,
        /// <summary>
        /// 巡检
        /// </summary>
        [Description("巡检")]
        Round = 2,
        /// <summary>
        /// 完工检
        /// </summary>
        [Description("完工检")]
        Complate = 3,
        /// <summary>
        /// 全检
        /// </summary>
        [Description("全检")]
        Full = 4
    }

    public enum FaultAlarmType
    {
        [Description("参数异常监控")]
        ParameterFault = 1,
        [Description("设备异常监控")]
        MachineFault,
        [Description("DNC程序监控")]
        DncFault,
        [Description("状态异常监控")]
        StateAlarm
    }

    public enum SliceStateEnum
    {
        [Description("正常")]
        Normal,
        [Description("报警")]
        Fault,
        [Description("关闭报警")]
        Close,
    }

    public enum MachineReportStatus
    {
        [Description("正常生产")]
        NormalProduct = 1,
        [Description("暂停生产")]
        StopProduct = 2,
        [Description("无工单")]
        NotWorkOrder = 3,
        [Description("未签到")]
        NotSignIn = 4,
    }

    public enum StationStatus
    {
        [Description("待生产")]
        WaitProduce = 1,
        [Description("生产中")]
        Producting,
        [Description("已暂停")]
        Paused,
        [Description("已完工")]
        Finished,
        [Description("已失效")]
        Failed
    }

    public enum DisposeType
    {
        [Description("标准工序返工")]
        Standard = 1,
        [Description("非标准工序返工")]
        NotStandard,
        [Description("工废")]
        IndustrialWaste,
        [Description("料废")]
        ScrapWaste
    }

    public enum ProcessMode
    {
        [Description("返工")]
        Rework = 1,
        [Description("报废")]
        Scarp,
        [Description("让步接收")]
        AcceptDeviation,
    }

    public enum ProcessState
    {
        [Description("待处理")]
        Pending = 1,
        [Description("处理中")]
        Processed,
        [Description("已完成")]
        Finished
    }

}
