﻿using System;

namespace  Siger.WeComApi.Core.Domain.BigData.ResultData
{
    public class CncSliceSate : ResultEntityBase
    {
        public int MachineID { get; set; }

        public DateTime StartTime { get; set; }

        public DateTime EndTime { get; set; }

        /// <summary>
        /// //0 关机 1 运行 2 调试 3 空闲 4 故障
        /// </summary>
        public int Status { get; set; }

        public DateTime UpdateTime { get; set; }

        public int WordingModeId { get; set; }

        public string WordingName { get; set; }
        //0->正常 1->报警 2->关闭报警
        public int IsException { get; set; }

        public string UserName { get; set; }

        public string Remark { get; set; }

        public int GroupBy { get; set; }

        public int Seconds { get; set; }
    }

    /// <summary>
    /// 切片状态，精简版实体
    /// </summary>
    public class CncSliceSateShort
    {
        public int MachineID { get; set; }

        /// <summary>
        /// 设备名称
        /// </summary>
        public string MachineName { get; set; }

        public DateTime StartTime { get; set; }

        public DateTime EndTime { get; set; }

        /// <summary>
        /// 持续时间
        /// </summary>
        public double Duration { get; set; }

        /// <summary>
        /// //0 关机 1 运行 2 调试 3 空闲 4 故障
        /// </summary>
        public int Status { get; set; }

        public string StatusName
        {
            get
            {
                switch (Status)
                {
                    case 1:
                        return "运行";
                    case 2:
                        return "调试";
                    case 3:
                        return "空闲";
                    default:
                        return "";

                }
            }
        }

        public int WordingModeId { get; set; }

        public string WordingName { get; set; }
    }

    public enum StatusCategory
    {
        Default, // 0：关机 1：运行 2：调试 3：空闲 4：报警

        HasChangeLine, // 5：换线调试 

        HasGrinding, // 6：磨削 7：整修 8：非磨削
    }
}
