﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.WeComApi.Core.Domain.Data
{
    public class ApiParams
    {
        public int ver { get; set; }
        public int companyid { get; set; }
        public int projectid { get; set; }
        public List<CutterLocationInfo> data { get; set; }
    }
    public class CutterLocationInfo
    {
        public string CutterLocationId { get; set; }
        public string SpindleId { get; set; }
        public int MachineCode { get; set; }
        public List<ProgramInfoApi> ProgramInfo { get; set; }
        public CutterLocationInfo()
        {
            ProgramInfo = new List<ProgramInfoApi>();
        }
    }
    public class ProgramInfoApi
    {
        public string Programno { get; set; }
        public string Program_type { get; set; }
    }
    public class CutterLocationList
    {
        public string cutter_location_id { get; set; }
        public string spindle_id { get; set; }
        public int machine_code { get; set; }
        public string program_str { get; set; }
        public string program_type_str { get; set; }
        public List<ProgramInfo> program_info { get; set; }
        public CutterLocationList()
        {
            program_info = new List<ProgramInfo>();
        }
    }
    public class ProgramInfo
    {
        public string programno { get; set; }
        public string program_type { get; set; }
    }
    public class ToolInfo
    {
        public string tool_name { get; set; }
        public string drawingcode { get; set; }
        public string supplier { get; set; }
        public int? ratedlife { get; set; }
        public int? program_type { get; set; }
        public int? surplus_life { get; set; }
        public string programno { get; set; }
        public decimal cyc_time { get; set; }
    }
}
