﻿
using Siger.WeComApi.Common.Enums.Extensions;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Siger.WeComApi.Core.Domain.Entity
{
    public class siger_project_skill_type: ConfigEntityBase
    {
        public siger_project_skill_type()
        {
            Status = 1;
        }
        /// <summary>
        /// Desc:
        /// Default:
        /// Nullable:False
        /// </summary>           
        public int Id { get; set; }

        /// <summary>
        /// Desc:
        /// Default:
        /// Nullable:False
        /// </summary>           
        public int ProjectId { get; set; }

        /// <summary>
        /// Desc:
        /// Default:1
        /// Nullable:False
        /// </summary>           
        public int Status { get; set; }

        /// <summary>
        /// Desc:技能名称
        /// Default:
        /// Nullable:False
        /// </summary>           
        public string SkillName { get; set; }

        /// <summary>
        /// Desc:部门id以逗号隔开
        /// Default:
        /// Nullable:True
        /// </summary>           
        public string Sections { get; set; }

        /// <summary>
        /// Desc:岗位id以逗号隔开
        /// Default:
        /// Nullable:True
        /// </summary>           
        public string Posts { get; set; }

        /// <summary>
        /// Desc:技能描述
        /// Default:
        /// Nullable:True
        /// </summary>           
        public string Description { get; set; }

        /// <summary>
        /// Desc:创建时间
        /// Default:
        /// Nullable:False
        /// </summary>           
        public DateTime CreateTime { get; set; }

        /// <summary>
        /// Desc:创建人id
        /// Default:
        /// Nullable:False
        /// </summary>           
        public int Creator { get; set; }

        /// <summary>
        /// Desc:修改时间
        /// Default:
        /// Nullable:False
        /// </summary>           
        public DateTime UpdateTime { get; set; }

        /// <summary>
        /// Desc:修改人id
        /// Default:
        /// Nullable:False
        /// </summary>           
        public int Updator { get; set; }

        /// <summary>
        /// 部门集合
        /// </summary>
        public List<int> SectionsList { get { return Sections.Split(',').Select(q => q.ToInt()).ToList(); } }

        /// <summary>
        /// 岗位集合
        /// </summary>
        public List<int> PostList { get { return Posts.Split(',').Select(q => q.ToInt()).ToList(); } }
    }
}
