﻿
using Siger.WeComApi.Common.Enums.Extensions;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.Linq;
using System.Text;

namespace Siger.WeComApi.Core.Domain.Entity
{
    public class siger_project_working_relation_user : ConfigEntityBase
    {
        public int projectid { get; set; }
        /// <summary>
        /// 部门ID
        /// </summary>
        public int section { get; set; }
        /// <summary>
        /// 班组别ID
        /// </summary>
        public int workgroup_id { get; set; }

        /// <summary>
        /// 人员ID
        /// </summary>
        public int employ { get; set; }
        /// <summary>
        /// 人员对多个工站 以逗号分隔
        /// </summary>
        public string stations { get; set; }
        /// <summary>
        /// 人员对多个设备 以逗号分隔
        /// </summary>
        public string machines { get; set; }

        /// <summary>
        /// 人员对多个多个设备集合
        /// </summary>
        [NotMapped]
        public List<int> machineSplit { get { return machines.TrimEnd(',').Split(',').Select(x => x.ToInt()).ToList(); } }

        /// <summary>
        /// 人员对多个工站的集合
        /// </summary>
        [NotMapped]
        public List<int> stationList { get { return stations.TrimEnd(',').Split(',').Select(q => q.ToInt()).ToList(); } }

    }
}
