﻿using Siger.WeComApi.Core.Dto.Request;
using System.Collections.Generic;

namespace Siger.WeComApi.Core.Dto.Response
{
    public class ResponseGetSectionTree
    {
        public ResponseGetSectionTree()
        {
            if (children == null)
            {
                children = new List<ResponseGetSectionTree>();
            }
        }
        public bool disabled { get; set; }
        public bool expand { get; set; }
        public int value { get; set; }
        public int attrubution { get; set; }
        public int levelid { get; set; }

        public string label { get; set; }
        /// <summary>
        /// 设备等级
        /// </summary>
        public int machinelevel { get; set; }
        public int machineid { get; set; }

        public List<ResponseGetSectionTree> children { get; set; }

        #region DashboardConfig控制器的接口GetSectionTree下的SigerProjectLevelSectionRepository方法需要
        public bool @checked { get; set; }
        public string acc_text_value { get; set; }
        public int right_article_num { get; set; }
        public double right_foot_offline { get; set; }
        public double right_foot_online { get; set; }
        #endregion
        public void Add(ResponseGetSectionTree child)
        {
            children.Add(child);
        }

        /// <summary>
        /// 设备ID
        /// </summary>
        public int mid { get; set; }
    }
    public class ResponseGetData
    {
        public List<ResponseGetSectionTree> data { get; set; }

        //灯的状态
        public int lampStatus { get; set; } = 0;
        //设备布局图
        public string layout { get; set; }
        //设备定位配置
        public List<RequestFixs> fixPath { get; set; }
    }

    public class RequestFixs
    {
        public int id { get; set; }
        public int fid { get; set; }
        /// <summary>
        /// 设备名称
        /// </summary>
        public string title { get; set; }
        /// <summary>
        /// x
        /// </summary>
        public int x { get; set; }
        /// <summary>
        /// y
        /// </summary>
        public int y { get; set; }

        public int section_id { get; set; }
    }
    public class ResponseTypeTree
    {
        public ResponseTypeTree()
        {
            if (children == null)
            {
                children = new List<ResponseTypeTree>();
            }
        }
        public int value { get; set; }
        public string label { get; set; }

        public List<ResponseTypeTree> children { get; set; }

        public void Add(ResponseTypeTree child)
        {
            children.Add(child);
        }
    }

    public class ResponseMachineType
    {
        /// <summary>
        /// 子级id
        /// </summary>
        public int childId { get; set; }
        /// <summary>
        /// 父级id
        /// </summary>
        public int parentId { get; set; }
        /// <summary>
        /// 父级设备
        /// </summary>
        public string parentMachine { get; set; }
        /// <summary>
        /// 子级设备
        /// </summary>
        public string childMachine { get; set; }
             
    }
}
