﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.ApiCommon.Filters;
using Siger.Middlelayer.AccRepository.Response;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Share.Enum.ModuleEnum;
// For more information on enabling Web API for empty projects, visit https://go.microsoft.com/fwlink/?LinkID=397860

namespace Siger.ApiACC.Controllers
{
    public class AutomationStateController : BaseController
    {
        private readonly ISigerProjectLevelSectionRepository _sigerProjectLevelSection;
        private readonly IAutomationMachineStatus _automationMachineStatus;
        private readonly IAutomationTaskListRepository _automationTaskList;
        private readonly IAutomationFixtureMonitor _automationFixtureMonitor;

        public AutomationStateController(ISigerProjectLevelSectionRepository sigerProjectLevelSection, IAutomationMachineStatus automationMachineStatus, IAutomationTaskListRepository automationTaskList, IAutomationFixtureMonitor automationFixtureMonitor)
        {
            _sigerProjectLevelSection = sigerProjectLevelSection;
            _automationMachineStatus = automationMachineStatus;
            _automationTaskList = automationTaskList;
            _automationFixtureMonitor = automationFixtureMonitor;
        }

        /// <summary>
        /// 产线监控管理
        /// </summary>
        /// <param name="section"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetStationMonitor(int section)
        {
            var ids = new List<int>();
            if (section != 0)
            {
                ids = _sigerProjectLevelSection.GetLevelSectionIds(section,ProjectId).ToList();
            }
            var data = _automationMachineStatus.GetSectionStatus(ProjectId, section,ids);

            var result = new List<ResponseAutomationMachineStatus>();
            foreach(var d in data)
            {
                var item = new ResponseAutomationMachineStatus
                {
                     sectionid=d.sectionid,
                     section=$"{ d.section} {d.linemode}",
                     enable=d.enable,
                     product="",
                     location=0,
                     sn="",
                     fixtureCode="",
                     fixtureName="",
                     lastupdate="",
                     status=(int)Automation.MachineStatus.Waiting,
                     linemode=d.linemode

                };
                var fixture = _automationFixtureMonitor.Get(f => f.section == d.sectionid);
                if (fixture!=null)
                {
                    item.product = fixture.productName;
                    item.location = fixture.locationId;
                    item.sn = fixture.sn;
                    item.fixtureCode = fixture.fixtureguid;
                 
                    item.fixtureName = fixture.fixturename;
                    item.status = fixture.status;
                }
                result.Add(item);

            }
            var output = new ResponseMachineMonitor
            {
           
                 sum=new ResponseAutomationMachineStatusTotal { 
                  waittingTotal =result.Where(f=>f.status==(int)Automation.MachineStatus.Waiting).Count(),
                  produceTotal= result.Where(f => f.status == (int)Automation.MachineStatus.Produce).Count(),
                  complateTotal= result.Where(f => f.status == (int)Automation.MachineStatus.Complated).Count(),
                  disableTotal= result.Where(f => f.enable ==0).Count(),
                 },
                 dts=result
            };
            return new ObjectResult(output);
        }
        [HttpGet]
        public IActionResult GetTasklist(int section, int tasktype, string productCode, string taskno, string sn, int status, int actionType, string triggertime, string complatetime,int page,int pageSize)
        {
            var ids = new List<int>();
            if (section != 0)
            {
                ids = _sigerProjectLevelSection.GetLevelSectionIds(section, ProjectId).ToList();
            }
            var resulst = _automationTaskList.GetTasklistPagedList(ids, tasktype, productCode, taskno, sn, status, actionType, triggertime, complatetime,ProjectId,page,pageSize);

            return new PagedObjectResult(resulst, resulst.Total, page, pageSize);
        }
    }
}
