﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Filters;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Repository.Repositories.Interface;


namespace Siger.ApiACC.Controllers
{
    /// <summary>
    /// C/S 端
    /// </summary>
    [NoTokenValidateFilter]
    public class ClientsController : BaseController
    {
        private readonly ISigerProjectLevelRepository _levelRepository;
        private readonly ISigerProjectLevelSectionRepository _levelSectionRepository;
        private readonly ISigerProjectProductRepository _sigerProjectProduct;
        private readonly ISnListRepository _snListRepository;
        private readonly ISigerProjectUserRepository _sigerProjectUser;

        public ClientsController(ISigerProjectLevelRepository sigerProjectLevel, ISigerProjectLevelSectionRepository sigerProjectLevelSection,ISigerProjectProductRepository sigerProjectProduct, ISnListRepository snListRepository
            ,ISigerProjectUserRepository sigerProjectUser)
        {
            _levelRepository = sigerProjectLevel;
            _levelSectionRepository = sigerProjectLevelSection;
            _sigerProjectProduct = sigerProjectProduct;
            _snListRepository = snListRepository;
            _sigerProjectUser = sigerProjectUser;
        }
        /// <summary>
        /// C/S 端 获取产线结构树
        /// </summary>
        /// <param name="projectId"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetLevelSectionTree(int projectId)
        {
            var maxLevel = _levelRepository.GetList(f => f.status == (int)RowState.Valid && f.projectid == projectId) .OrderByDescending(q => q.id).FirstOrDefault();
            var alltreedata = _levelSectionRepository.getAllTreeData(projectId);
            var ret= _levelSectionRepository.GetSectionChildren(alltreedata, 0, projectId, maxLevel?.levelid ?? 0);
            return new ObjectResult(ret);
        }
        /// <summary>
        /// C/S 端 获取产线结构
        /// </summary>
        /// <param name="projectId"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetLeveSection(int projectId)
        {
            var data = _levelSectionRepository.GetList(f => f.projectid == projectId && f.status == (int)RowState.Valid);
            if (!data.Any())
                throw new ClientException(EnumHelper.GetEnumDesc(CommonEnum.RecordNotFound));

            return new ObjectResult(data);
        }
        /// <summary>
        /// 获取项目人员信息
        /// </summary>
        /// <param name="projectId"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetProjectUsers(int projectId)
        {
            var userInfos = _sigerProjectUser.GetUserInfoList(ProjectId);
            if (!userInfos.Any())
                throw new ClientException(EnumHelper.GetEnumDesc(CommonEnum.RecordNotFound));

            return new ObjectResult(userInfos);
        }

        /// <summary>
        /// 获取项目产品信息
        /// </summary>
        /// <param name="projectId"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetProduct(int projectId)
        {
            var list = _sigerProjectProduct.GetList(f=>f.projectid==projectId && f.status==(int)RowState.Valid);
            if (!list.Any())
                throw new ClientException(EnumHelper.GetEnumDesc(CommonEnum.RecordNotFound));

            var result = new List<ResponseIdText>();
            foreach(var obj in list)
            {
                result.Add(new ResponseIdText
                {
                    id=obj.code,
                    Text=$"{obj.code}({obj.name})",
                });
            }
            return new ObjectResult(result);
        }

        /// <summary>
        /// 获取订单/工单 信息
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="sn"></param>
        /// <returns></returns>
        [HttpGet]

        public IActionResult GetWoInfo(int projectId,string sn)
        {
            var result = _snListRepository.GetWoInfo(sn, projectId);
            if (!result.Any())
                throw new ClientException(EnumHelper.GetEnumDesc(CommonEnum.RecordNotFound));
            return new ObjectResult(result.FirstOrDefault());
        }
    }
}
