﻿using System;
using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.CncRepository.Response;

namespace Siger.ApiCNC.Result
{
    public class ListMachineYieldBySignResult: CncResultBase
    {
        public IList<string> xdata { get; set; }

        public IList<int> ydata { get; set; }

        public IList<ResponseGetListMachineYieldBySign> data { get; set; }

        public ListMachineYieldBySignResult()
        {
            xdata = new List<string>();
            ydata = new List<int>();
            data = new List<ResponseGetListMachineYieldBySign>();
        }
    }

    public class ListMachineYieldsResult : CncResultBase
    {
        public IList<string> xdata { get; set; }

        public IList<int> ydata { get; set; }

        public IList<ResponseGetListMachineYield> data { get; set; }

        public ListMachineYieldsResult()
        {
            xdata = new List<string>();
            ydata = new List<int>();
            data = new List<ResponseGetListMachineYield>();
        }
    }

    public class ElectricStatisticsResult : CncResultBase
    {
        public IList<string> xdata { get; set; }

        public IList<double> ydata { get; set; }

        public IList<ElectricStatistics> data { get; set; }

        public ElectricStatisticsResult()
        {
            xdata = new List<string>();
            ydata = new List<double>();
            data = new List<ElectricStatistics>();
        }
    }

    public class ElectricStatistics
    {
        public string title { get; set; }

        public double electric { get; set; }
    }

    public class WorkingHourStatisticsResult : CncResultBase
    {
        public IList<string> xdata { get; set; }

        public IList<double> ydata { get; set; }

        public IList<WorkingHourListData> data { get; set; }

        public WorkingHourStatisticsResult()
        {
            xdata = new List<string>();
            ydata = new List<double>();
            data = new List<WorkingHourListData>();
        }
    }

    public class WorkingHourStatistics
    {


        /// <summary>
        /// 工单号
        /// </summary>
        public string ordernumber { get; set; }

        /// <summary>
        /// 工令号
        /// </summary>
        public string code { get; set; }

        public string product_name { get; set; }

        public double working_hour { get; set; } = 0;

        public double prepare { get; set; } = 0;

        public double total { get; set; } = 0;

        public string user_name { get; set; }

        public string work_code { get; set; }

        public string group_name { get; set; }

        public string gonglingdan { get; set; }
        /// <summary>
        /// 产线层级title
        /// </summary>
        public string sectionidtitle { get; set; }
    }

    public class WorkingHourListData
    {
        /// <summary>
        /// 报工人
        /// </summary>
        public string username { get; set; }
        /// <summary>
        /// 工号
        /// </summary>
        public string usercode{ get; set; }
        /// <summary>
        /// 工单号
        /// </summary>
        public string code { get; set; }
        /// <summary>
        /// 工令单
        /// </summary>
        public string workcode { get; set; }
        /// <summary>
        /// 订单号
        /// </summary>
        public string orderno { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string machine { get; set; }
        public string productname { get; set; }
        public string productdraw { get; set; }
        public string routename { get; set; }
        public int okcnt { get; set; }
        public int ngcnt { get; set; }
        /// <summary>
        /// 生产工时min
        /// </summary>
        public double workingmin { get; set; }
        /// <summary>
        /// 报工时间
        /// </summary>
        public int time { get; set; }
    }
}
