﻿using Siger.Middlelayer.Common.ModuleEnum;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiCommon.Utilities
{
    public class CommonUtility
    {
        public static string GetAlarmColor(AlarmGrade alarmGrade)
        {
            string color = ToolConst.Alarm.NORMAL_COLOR;
            switch (alarmGrade)
            {
                case AlarmGrade.ToolDieLine:
                    color = ToolConst.Alarm.LIFE_ERROR_COLOR;
                    break;
                case AlarmGrade.Wear:
                    color = ToolConst.Alarm.TIPPING_COLOR;
                    break;
                case AlarmGrade.Quality:
                    color = ToolConst.Alarm.QUALITY_COLOR;
                    break;
                case AlarmGrade.Broken:
                    color = ToolConst.Alarm.CUTTER_BROKE_COLOR;
                    break;
                case AlarmGrade.Destroyed:
                    color = ToolConst.Alarm.CUTTER_DESTROYED;
                    break;
                default:
                    color = ToolConst.Alarm.NORMAL_COLOR;
                    break;
            }
            return color;
        }
    }
}
