﻿using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.DncRepository.Entities;
using Siger.Middlelayer.DncRepository.Response;
using Siger.Middlelayer.Repository.Response;

namespace Siger.ApiDNC.Controllers
{
    [Route("dnc/[controller]/[action]")]
    [ApiController]
    public class BaseController : AuthController
    {

        protected Dictionary<string, string> GetUpdatedPrograms(IEnumerable<siger_project_dnc_job_program> jobPrograms,IEnumerable<string> pros)
        {
            //判断程序是否被修改
            var isUpdate = new Dictionary<string, string>();
            foreach (var programNumber in pros)
            {
                var leastestdata = jobPrograms.Where(f => f.program_number == programNumber).OrderByDescending(f => f.time).FirstOrDefault();
                if (leastestdata != null)
                {
                    //是update状态返回状态及时间
                    if (leastestdata.type.ToUpper() == ChangeProgramType.Update.ToString().ToUpper())
                    {
                        var time = UnixTimeHelper.ConvertDataTimeLong(leastestdata.time.ToLocalTime()).ToString();
                        isUpdate.Add(programNumber, time);
                    }
                }
            }

            return isUpdate;
        }


        /// <summary>
        /// 拼接处理显示数据
        /// </summary>
        /// <param name="machine"></param>
        /// <param name="pros"></param>
        /// <param name="checkProgram"></param>
        /// <param name="isUpdates"></param>
        /// <returns></returns>
        protected List<ResponseGetPguploadlists> ClcaProgramInfo(ResponseGetSectionMachine machine, List<string> pros, IEnumerable<ResponseAllPrograms> checkProgram
        , Dictionary<string, string> isUpdates)
        {
            var result = new List<ResponseGetPguploadlists>();
            //添加所有数据库中查询到的数据
            foreach (var item in checkProgram)
            {
                var tmp = new ResponseGetPguploadlists
                {
                    programid = item.id,
                    machine_name = machine.title,
                    machine_id = machine.id,
                    program_code = item.program_code,
                    product_code = item.productcode,
                    product_name = item.productname,
                    createname = item.createname,
                    createtime = item.createtime == 0 ? "NA" : UnixTimeHelper.ConvertIntDateTime(item.createtime),
                    create_remark = item.create_remark ?? "NA",
                    checkname = item.checkname,
                    checktime = item.checktime == 0 ? "NA" : UnixTimeHelper.ConvertIntDateTime(item.checktime),
                    check_remark = item.check_remark,
                    uploadname=string.IsNullOrEmpty(item.uploadname) ? "NA" : item.uploadname,
                    uploadtime= string.IsNullOrEmpty(item.uploadtime) ? "NA" : item.uploadtime,
                    filesize= string.IsNullOrEmpty(item.filesize) ? "NA" : item.filesize,
                    filename = string.IsNullOrEmpty(item.file_name) ? "NA" : item.file_name
                };
                result.Add(tmp);
            }
            //添加数据库中未查到的数据
            foreach (var item in pros)
            {
                if (!result.Exists(f => f.program_code == item))
                {
                    var tmp = new ResponseGetPguploadlists
                    {
                        machine_name = machine.title,
                        machine_id = machine.id,
                        program_code=item
                    };
                    result.Add(tmp);
                }
            }
            //添加是否更新的字段
            foreach (var item in result)
            {
                if (isUpdates.Any(f => f.Key == item.program_code))
                {
                    item.updatestatus = 1;
                    item.updatetime = isUpdates[item.program_code] ?? "NA";
                }
            }
            result.Sort();
            return result;
        }

    }
}