﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Siger.ApiDashboard.Tasks.Model
{
    public class StopStateOfMachineResult
    {
        public StopStateOfMachineResult()
        {
            echartData = new List<StopState_EcharData>();
            tableData = new List<StopState_tableData>();
        }
        /// <summary>
        /// /// UI 画图主键
        /// </summary>
        public string type { get; set; } = "MachineStateOfStop";
        public string title { get; set; }
        /// <summary>
        /// Echart图标
        /// </summary>
        public List<StopState_EcharData> echartData { get; set; }

        /// <summary>
        /// 列表
        /// </summary>
        public List<StopState_tableData> tableData { get; set; }
    }
    public class StopState_EcharData
    {
        public StopState_EcharData()
        {
            xdata = new List<string>();
            ydata1 = new List<double>();
            ydata2 = new List<double>();
        }
        public double markingline { get; set; }
        public List<string> xdata { get; set; }
        public List<double> ydata1 { get; set; }
        public List<double> ydata2 { get; set; }
    }
    public class StopState_tableData
    {
        /// <summary>
        /// 组设备
        /// </summary>
        public string datetime { get; set; }
        /// <summary>
        /// 生产效率 百分比
        /// </summary>
        public double num1 { get; set; }
        /// <summary>
        /// 标准值差异 百分比
        /// </summary>
        public double num2 { get; set; }
        /// <summary>
        /// 生产效率 /小时
        /// </summary>
        public double hour1 { get; set; }
        /// <summary>
        /// 标准值差异 百分比
        /// </summary>
        public double hour2 { get; set; }
    }
}
