﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Repositories.Interface;
using Siger.Middlelayer.KpiRespository.Repositories.Interface;
using Siger.Middlelayer.KpiRespository.Request;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Share.ModuleEnum;
using Siger.Middlelayer.Share.Enum.ModuleEnum;
using Siger.Middlelayer.Common.Helpers;

namespace Siger.ApiKPI.Controllers
{
    public class AutoCalculationController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly ISigerKpiAutoCalculation _sigerKpiAuto;
        private readonly ISigerKpiItem _sigerKpiItem;
        private readonly ISigerProjectLevelSectionRepository _sigerProjectLevelSection;

        public AutoCalculationController(IUnitOfWork unitOfWork,ISigerKpiAutoCalculation sigerKpiAuto,ISigerKpiItem sigerKpiItem,ISigerProjectLevelSectionRepository sigerProjectLevelSection)
        {
            _unitOfWork = unitOfWork;
            _sigerKpiAuto = sigerKpiAuto;
            _sigerKpiItem = sigerKpiItem;
            _sigerProjectLevelSection = sigerProjectLevelSection;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="section"></param>
        /// <param name="item"></param>
        /// <param name="page"></param>
        /// <param name="pageSize"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult Getlist(int section,string item,int page,int pageSize)
        {
            var data = _sigerKpiAuto.GetPagedCollectionResult(section, item, ProjectId, page, pageSize);
            var result = data.Data.ToList();
            foreach (var d in result)
            {
                var level = _sigerProjectLevelSection.Get(f => f.id == d.Line);
                var autoEnum = (DashboardTotalRate)d.AutoKey;
                d.AutoDesc = EnumHelper.GetEnumDesc(autoEnum);
                d.LinePosition = level != null ? level.title : d.Line.ToString();
            }
            return new PagedObjectResult(result, data.Total, page, pageSize);
        }
        private string GetAllTitle(int sectionId)
        {
            var titles = _sigerProjectLevelSection.GetLevelSectionTitles(sectionId, ProjectId);
            var list = titles.ToList();
            return list.Any() ? string.Join('-', list) : string.Empty;
        }
        /// <summary>
        /// 添加
        /// </summary>
        /// <param name="auto"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Add([FromBody]RequestAuto auto)
        {
            if (auto.section==0 || string.IsNullOrEmpty(auto.item) || auto.line==0 || auto.autokey==0)
                throw new BadRequestException(RequestEnum.ParameterMiss);
            var cycle = (KpiCycleEnum)auto.cycle;
            var itemObj = _sigerKpiItem.Get(f => f.projectId == ProjectId && f.Item == auto.item && f.KpiCycle == cycle);
            if (itemObj==null)
                throw new BadRequestException(CommonEnum.RecordNotFound);
            _sigerKpiAuto.Insert(new Middlelayer.KpiRespository.Entities.SigerProjectKpiIAutoCalculation
            {
                Section=auto.section,
                Item= itemObj.id,
                projectId=ProjectId,
                Line=auto.line,
                AutoTarget=auto.autokey,
                Interval=1,
                Mid=UserId,
                Datetime=DateTime.Now,
                status=(int)RowState.Valid
            });

            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            else
                return new ObjectResult(CommonEnum.Fail);
        }
        /// <summary>
        ///  修改
        /// </summary>
        /// <param name="auto"></param>
        /// <returns></returns>
        [HttpPost]
        public IActionResult Modify([FromBody]RequestAuto auto)
        {
            var obj = _sigerKpiAuto.Get(f => f.projectId == ProjectId && f.id == auto.id);
            if (obj==null)
                throw new BadRequestException(CommonEnum.RecordNotFound);
            var cycle = (KpiCycleEnum)auto.cycle;
            var itemObj = _sigerKpiItem.Get(f => f.projectId == ProjectId && f.Item == auto.item && f.KpiCycle == cycle);
            if (itemObj == null)
                throw new BadRequestException(CommonEnum.RecordNotFound);

            obj.Section = auto.section;
            obj.Item = itemObj.id;
            obj.Mid = UserId;
            obj.Datetime = DateTime.Now;
            obj.AutoTarget = auto.autokey;
            _sigerKpiAuto.Update(obj);

            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            else
                return new ObjectResult(CommonEnum.Fail);
        }
        /// <summary>
        ///  删除
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpGet]
        public IActionResult Del(int id)
        {
            var obj = _sigerKpiAuto.Get(f => f.projectId == ProjectId && f.id ==id);
            if (obj == null)
                throw new BadRequestException(CommonEnum.RecordNotFound);

            _sigerKpiAuto.Delete(obj.id);

            if (_unitOfWork.Commit() > 0)
                return new ObjectResult(CommonEnum.Succefull);
            else
                return new ObjectResult(CommonEnum.Fail);
        }
    }
}
