﻿using System;
using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Entities;
using Siger.Middlelayer.Repository.Response;
using Siger.Middlelayer.TpmRepository.Repositories.Interface;

namespace Siger.ApiTPM.Utilities
{
    public class MachineLocationHelper
    {
        private readonly IPlanRepository _plan;
        private readonly int _projectId;
        public MachineLocationHelper(int projectId, IPlanRepository plan)
        {
            _plan = plan;
            _projectId = projectId;
        }

        public List<string> GetLocations(List<string> locationArr)
        {
            //var locationList = new List<string>();
            //if (locationArr.Count == 0)
            //{
            //    return locationList;
            //}
            //if (locationArr.Count >= 3)
            //{
            //    var lastone = locationArr[locationArr.Count - 2];
            //    var lasttwo = locationArr[locationArr.Count - 1];
            //    locationList.Add(lastone + "-" +lasttwo);
            //    var locations = locationArr.ToList();
            //    locations.Remove(lastone);
            //    locations.Remove(lasttwo);
            //    locationList.Add(string.Join('-', locations));
            //}
            //else
            //{
            //    var lastone = locationArr[locationArr.Count - 1];
            //    locationList.Add(lastone);
            //    var locations = locationArr.ToList();
            //    locations.Remove(lastone);
            //    locationList.Add(string.Join('-', locations));
            //}
            //return locationList;

            return locationArr;
        }

        /// <summary>
        /// 根据machineId获取设备位置
        /// </summary>
        /// <param name="machineId"></param>
        /// <returns></returns>
        public List<string> GetPositionByMachineId(int machineId)
        {
            return _plan.GetMachineNames(machineId, _projectId);
        }

        public List<ResponseIdTitle> GetPositionByMachineId(IEnumerable<int> machineIds)
        {
            return _plan.GetMachineNames(machineIds, _projectId);
        }

        /// <summary>
        /// 根据machineId获取设备位置
        /// </summary>
        /// <param name="machineId"></param>
        /// <param name="levelSections"></param>
        /// <returns></returns>
        public List<string> GetPositionByMachineIdForLoop(int machineId, IEnumerable<siger_project_level_section> levelSections)
        {
            return _plan.GetMachineNames(machineId, _projectId);
        }

        public List<string> GetLocationsByMahcineIdForLoop(int machineId, IEnumerable<siger_project_level_section> levelSections)
        {
            return GetLocations(GetPositionByMachineIdForLoop(machineId, levelSections));
        }

        private IEnumerable<siger_project_level_section> GetParentSelfLevelSections(int parentid, int projectid, IEnumerable<siger_project_level_section> levelSections)
        {
            var query = from c in levelSections
                where c.id == parentid && c.status == (int)RowState.Valid
                select c;

            return query.ToList().Concat(query.ToList().SelectMany(t => GetParentLevelSections(t.parentid, projectid, levelSections)));
        }

        private IEnumerable<siger_project_level_section> GetParentLevelSections(int id, int projectid, IEnumerable<siger_project_level_section> levelSections)
        {
            var query = from c in levelSections
                where c.id == id && c.status == (int)RowState.Valid && c.projectid == projectid
                select c;

            return query.ToList().Concat(query.ToList().SelectMany(t => GetParentLevelSections(t.parentid, projectid, levelSections)));
        }
    }
}
