﻿using System.Collections.Generic;
using System.Linq;
using Microsoft.AspNetCore.Mvc;
using Siger.ApiCommon.Result;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Common.ModuleEnum;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common.Helpers;
using Siger.Middlelayer.WmsRepository.Repositories.Interface;
using Siger.Middlelayer.WmsRepository.Response;

namespace Siger.ApiWMS.Controllers
{
    /// <summary>
    /// 
    /// </summary>
    public class StockAlarmController : BaseController
    {
        private readonly IUnitOfWork _unitOfWork;
        private readonly Isiger_wms_stock_alarmRepository _AlarmRepository;
        private readonly Isiger_wms_stockRepository _StockRepository;

        /// <summary>
        /// 
        /// </summary>
        /// <param name="unitOfWork"></param>
        /// <param name="AlarmRepository"></param>
        /// <param name="StockRepository"></param>
        public StockAlarmController(IUnitOfWork unitOfWork, Isiger_wms_stock_alarmRepository AlarmRepository, Isiger_wms_stockRepository StockRepository)
        {
            _unitOfWork = unitOfWork;
            _AlarmRepository = AlarmRepository;
            _StockRepository = StockRepository;
        }

        /// <summary>
        /// 获取分页列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public IActionResult GetPagedList(string material, int page = 1, int pagesize = 10)
        {
            Utility.CheckPage(page, pagesize);
            var result = _AlarmRepository.GetPagedList(material.ToInt(), ProjectId, page, pagesize);
            var res = new List<ResponseStockAlarm>();
            foreach(var item in result.Data)
            {
                var model = Mapper<ResponseStockAlarm, ResponseStockAlarm>.Map(item);
                if(model.status != (int)AlarmStatus.Operated)
                {
                    model.quantity = _StockRepository.GetList(t => t.material_id == item.material_id && t.status == (int)RowState.Valid &&
                        t.projectid == ProjectId && t.stock_state == (int)StockEnum.InWavehouse).Sum(t => t.quantity);
                }
                res.Add(model);
            }
            return new PagedObjectResult(res, result.Total, page, pagesize);
        }

        [HttpGet]
        public IActionResult DealWith(int id)
        {
            var entity = _AlarmRepository.Get(t => t.id == id && t.status == (int)RowState.Valid && t.projectid == ProjectId);
            if(entity == null)
            {
                throw new BadRequestException(CommonEnum.RecordNotFound);
            }

            entity.status = (int)AlarmStatus.Operated;
            entity.operate_mid = UserId;
            entity.operate_time = UnixTimeHelper.GetNow();
            entity.stock_quantity = _StockRepository.GetList(t => t.material_id == entity.material_id && t.status == (int)RowState.Valid &&
                    t.projectid == ProjectId && t.stock_state == (int)StockEnum.InWavehouse).Sum(t => t.quantity);
            _AlarmRepository.Update(entity);
            if (_unitOfWork.Commit() > 0)
            {
                return new ObjectResult(CommonEnum.Succefull);
            }
            throw new BadRequestException(CommonEnum.Fail);
        }
    }
}