﻿
using System.Text.RegularExpressions;

namespace Siger.Middlelayer.Common.Helpers
{
    public class TokenHelper
    {
        public const string Prefix = "Token_";

        public static TokenInfo Generate()
        {
            var key = Prefix + IdHelper.Generate<string>();
            var value = DesBuilder.Encrypt(key);

            return new TokenInfo(key, value);
        }

        public static string Splicing(string companyId, int projectId, int userId, int roleid)
        {
            return $"{companyId}_{projectId}_{userId}_{roleid}";
        }

        public static string GetQueryString(string name, string url)
        {
            Regex re = new Regex(@"(^|&)?(\w+)=([^&]+)(&|$)?", RegexOptions.Compiled);
            MatchCollection mc = re.Matches(url);
            foreach (Match m in mc)
            {
                if (m.Result("$2").Equals(name))
                {
                    return m.Result("$3");
                }
            }
            return "";
        }
    }

    public class TokenInfo
    {
        public string Key { get; private set; }

        public string Value { get; private set; }

        public TokenInfo(string key, string value)
        {
            Key = key;
            Value = value;
        }
    }
}
