﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Siger.Middlelayer.Utility.ExcelImport
{
    public class BeatSetEntity
    {
        public List<string> Levels { get; set; }

        [ExcelColumn("加工程序号")]
        [EmptyValidate("ProgramNoIsEmpty")]
        public string ProgramNo { get; set; }

        [ExcelColumn("产品名称")]
        public string ProductName { get; set; }

        [ExcelColumn("产品图纸号")]
        [EmptyValidate("ProductDrawCodeIsEmpty")]
        public string ProductDrawingCode { get; set; }

        [ExcelColumn("工序名称")]
        [EmptyValidate("RouteNameIsEmpty")]
        public string RouteName { get; set; }

        [ExcelColumn("标准节拍")]
        [EmptyValidate("BeatSetIsEmpty")]
        public string CycleTime { get; set; }

        [ExcelColumn("日标准产量")]
        [EmptyValidate("OutputIsEmpty")]
        public string OutPut { get; set; }

        [ExcelColumn("换型时间")]
        public string ChangeModelTime { get; set; }

        [ExcelColumn("上下料节拍")]
        public string UpDownBesat { get; set; }

        [ExcelColumn("产量系数")]
        public string YieldRate { get; set; }

        [ExcelColumn("工序顺序")]
        public string RouteNumber { get; set; }

        [ExcelColumn("开始时间")]
        public string StartTime { get; set; }

        [ExcelColumn("结束时间")]
        public string EndTime { get; set; }

        public BeatSetEntity()
        {
            Levels = new List<string>();
        }
    }
}
