﻿using Siger.Middlelayer.Utility.ExcelImport;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    public class SendTestCollectionList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int No { get; set; }
        [ExcelColumn("产品编号")]
        public string ProductCode { get; set; }
        [ExcelColumn("产品名称")]
        public string ProductName { get; set; }
        [ExcelColumn("物料编号")]
        public string MaterialPn { get; set; }
        [ExcelColumn("物料名称")]
        public string MaterialName { get; set; }
        [ExcelColumn("物料规格")]
        public string MaterialSpec { get; set; }
        [ExcelColumn("送检位置")]
        public string Section { get; set; }
        [ExcelColumn("检测室")]
        public string TestRoom { get; set; }
        [ExcelColumn("送检数量")]
        public string Number { get; set; }
        [ExcelColumn("偏差放行数量")]
        public string Quantity { get; set; }
        [ExcelColumn("二维码")]
        public string SN { get; set; }
        [ExcelColumn("送检类型(1->首检;2->巡检;3->末检;4->标准件检;5->首件检验)")]
        public int CheckType { get; set; }
        [ExcelColumn("送检原因")]
        public string Reason { get; set; }
        [ExcelColumn("状态(1->待接收;2->检测完成;3->待检验;4->检验中)")]
        public int CheckStatus { get; set; }
        [ExcelColumn("结果(1->合格;2->偏差放行;3->不合格)")]
        public string Result { get; set; }
        [ExcelColumn("送检人")]
        public string SendUser { get; set; }
        [ExcelColumn("送检时间")]
        public string SendTime { get; set; }
        [ExcelColumn("接收人")]
        public string RecieveUser { get; set; }
        [ExcelColumn("接收时间")]
        public string RecieveTime { get; set; }
        [ExcelColumn("开始检验人")]
        public string CheckingUser { get; set; }
        [ExcelColumn("开始检验时间")]
        public string CheckingTime { get; set; }
        [ExcelColumn("检验人")]
        public string CheckUser { get; set; }
        [ExcelColumn("检验时间")]
        public string CheckTime { get; set; }
    }

    public class SendTestCollectionDetailList : ImportBase
    {
        [ExcelColumn("序号")]
        [DonnetCreate]
        public int No { get; set; }
        [ExcelColumn("项目")]
        public string Item { get; set; }
        [ExcelColumn("标准")]
        public string Standard { get; set; }
        [ExcelColumn("下限")]
        public string MinValue { get; set; }
        [ExcelColumn("上限")]
        public string MaxValue { get; set; }
        [ExcelColumn("标准极差")]
        public string Range { get; set; }
        [ExcelColumn("结果")]
        public string DetailResult { get; set; }
        [ExcelColumn("实际最小值")]
        public string LowerLimit { get; set; }
        [ExcelColumn("实际最大值")]
        public string UpperLimit { get; set; }
        [ExcelColumn("单值")]
        public string Value { get; set; }
        [ExcelColumn("实际极差")]
        public string ActualRange { get; set; }
    }
}
