﻿using Siger.Middlelayer.Utility.ExcelImport;
using System;

namespace Siger.Middlelayer.Utility.ImportEntities
{
    /// <summary>
    /// 刀位导入导出
    /// </summary>
    public class ToolUseData : ImportBase
    {
        [ExcelColumn("序号")]
        public string SerialNo { get; set; }
        [ExcelColumn("刀具名称")]
        public string Name { get; set; }
        [ExcelColumn("料号")]
        public string MaterialCode { get; set; }
        [ExcelColumn("供应商")]
        public string Supplier { get; set; }
        [ExcelColumn("安装位置")]
        public string Location { get; set; }
        [ExcelColumn("刀位号")]
        public string Position { get; set; }
        [ExcelColumn("安装人")]
        public string Installer { get; set; }
        [ExcelColumn("安装时间")]
        public DateTime InstallTime { get; set; }
        [ExcelColumn("加工件数")]
        public int ProcessCount { get; set; }
        [ExcelColumn("卸载原因")]
        public string Reason { get; set; }
        [ExcelColumn("卸载时间")]
        public DateTime UninstallTime { get; set; }

    }

    public class ToolProcessData : ImportBase
    {
        [ExcelColumn("刀具名称")]
        public string Name { get; set; }
        [ExcelColumn("料号")]
        public string Material { get; set; }
        [ExcelColumn("供应商")]
        public string Supplier { get; set; }
        [ExcelColumn("使用位置")]
        public string Location { get; set; }
        [ExcelColumn("断刀率(%)")]
        public int Broken { get; set; }
        [ExcelColumn("磨损率(%)")]
        public int Collapse { get; set; }
        [ExcelColumn("崩刃率(%)")]
        public int Damage { get; set; }
        [ExcelColumn("平均加工数量")]
        public int ProcessCount { get; set; }

    }

    public class ExportToolInstallInfo : ImportBase
    {
        /// <summary>
        /// 设备
        /// </summary>
        [ExcelColumn("设备")]
        public string machineName { get; set; }
        /// <summary>
        /// 刀位
        /// </summary>
        [ExcelColumn("刀位")]
        public string toolLocaltion { get; set; }
        /// <summary>
        /// 道具编号
        /// </summary>
        [ExcelColumn("道具编号")]
        public string toolCode { get; set; }
        /// <summary>
        /// 刀具条形码
        /// </summary>
        [ExcelColumn("刀具条形码")]
        public string serialNumber { get; set; }
        /// <summary>
        /// 刀具名称
        /// </summary>
        [ExcelColumn("刀具名称")]
        public string toolName { get; set; }
        /// <summary>
        /// 安装时间
        /// </summary>
        [ExcelColumn("安装时间")]
        public string installTime { get; set; }
        /// <summary>
        /// 安装人员
        /// </summary>
        [ExcelColumn("安装人员")]
        public string installUser { get; set; }
        /// <summary>
        /// 卸载时间
        /// </summary>
        [ExcelColumn("卸载时间")]
        public string uninstallTime { get; set; }
        /// <summary>
        /// 卸载原因
        /// </summary>
        [ExcelColumn("卸载原因")]
        public string uninstallReason { get; set; }
        /// <summary>
        /// 加工件数？
        /// </summary>
        [ExcelColumn("加工件数")]
        public int life { get; set; }
        /// <summary>
        /// 供应商
        /// </summary>
        [ExcelColumn("供应商")]
        public string supplier { get; set; }
    }

    public class ExportImsInstallInfo : ImportBase
    {
        /// <summary>
        /// 设备
        /// </summary>
        [ExcelColumn("设备")]
        public string machineName { get; set; }
        /// <summary>
        /// 刀位
        /// </summary>
        [ExcelColumn("腔模号")]
        public string toolLocaltion { get; set; }
        /// <summary>
        /// 模具编号
        /// </summary>
        [ExcelColumn("模具编号")]
        public string toolCode { get; set; }
        /// <summary>
        /// 刀具条形码
        /// </summary>
        [ExcelColumn("模具条形码")]
        public string serialNumber { get; set; }
        /// <summary>
        /// 刀具名称
        /// </summary>
        [ExcelColumn("模具名称")]
        public string toolName { get; set; }
        /// <summary>
        /// 安装时间
        /// </summary>
        [ExcelColumn("安装时间")]
        public string installTime { get; set; }
        /// <summary>
        /// 安装人员
        /// </summary>
        [ExcelColumn("安装人员")]
        public string installUser { get; set; }
        /// <summary>
        /// 卸载时间
        /// </summary>
        [ExcelColumn("卸载时间")]
        public string uninstallTime { get; set; }
        /// <summary>
        /// 卸载原因
        /// </summary>
        [ExcelColumn("卸载原因")]
        public string uninstallReason { get; set; }
        /// <summary>
        /// 加工件数？
        /// </summary>
        [ExcelColumn("加工件数")]
        public int life { get; set; }
        /// <summary>
        /// 供应商
        /// </summary>
        [ExcelColumn("供应商")]
        public string supplier { get; set; }
    }
}
