﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Response;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class InspectStandardRepository : AccRepositoryBase<siger_qms_inspection_standard>, IInspectStandardRepository
    {
        private ApiAccDbContext _context;
        public InspectStandardRepository(ApiAccDbContext context) : base(context)
        {
            _context = context;
        }

        public ResponseIdName GetMachineBySectionId(int sectionId, int projectId)
        {
            var query = _context.siger_project_machine_attribution.FirstOrDefault(q =>
                q.station == sectionId && q.status == (int)RowState.Valid && q.attribution == (int)MachineAttributionEnum.equipment);
            if (query == null)
            {
                return null;
            }

            var machine = _context.siger_project_machine.FirstOrDefault(q =>
                q.projectid == projectId && q.status == (int)RowState.Valid
                                         && q.id == query.machine);
            if (machine == null)
            {
                return null;
            }

            return new ResponseIdName { id = machine.id, name = machine.title };
        }
    }
}
