﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;
using System.Collections.Generic;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface IAutomationFixtureToolsProductRepository : IAccRepositoryBase<siger_automation_fixture_tools_product>
    {
        IPagedCollectionResult<ResponseAumationFixtureToolsProduct> GetPagedList(int category, int tool, int product, int projectid, int page, int pagesize, string toexcel);

        ResponseProductFixtureInfo GetFixtureInfoByProductCode(int projectId, string productCode);


        /// <summary>
        /// 工令单获取 工装信息
        /// </summary>
        /// <param name="ordernumber"></param>
        /// <returns></returns>
        ResponsePlanlFixtureInfo GetPlanFixtureInfo(int projectId, string ordernumber);

        /// <summary>
        /// 
        /// </summary>
        /// <param name="projectId"></param>
        /// <param name="ordernumber"></param>
        /// <returns></returns>
        ResponsePlanlFixtureInfo GetPlanFixtureInfoByLocation(int projectId, int id);

        CommonImportResult ImportData(IEnumerable<FixtureToolsProductTemplate> list, int projectid, int userid);

        /// <summary>
        /// 获取交期最近的订单
        /// </summary>
        /// <param name="productIds"></param>
        /// <param name="projectId"></param>
        /// <returns></returns>
        IEnumerable<ResponseAutomationPlanOrder> GetDeliveryOrder(List<int> productIds, int projectId);

    }
}
