﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Paged;
using Siger.Middlelayer.Utility.ImportEntities;
using System.Collections.Generic;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface IAutomationLocationRepository : IAccRepositoryBase<siger_automation_location>
    {
        IPagedCollectionResult<ResponseAutomationLocation> GetPagedList(int wavehouseid, IEnumerable<int> locationid, int projectid, int page, int pagesize, string toexcel);


        siger_wms_storage_location GetLocation(int id, int projectid);

        /// <summary>
        /// 获取储位
        /// </summary>
        /// <param name="projectid">项目ID</param>
        /// <param name="hasMaterial">只查有SN</param>
        /// <returns></returns>
        IEnumerable<ResponseAutomationLocationList> GetDataList(int projectid, int hasMaterial);

        IEnumerable<siger_wms_storage_location> GetLocationList(int projectid);

        CommonImportResult ImportData(IEnumerable<AutomationLocationTemplate> list, int projectid, int userid);
    }
}
