﻿using System;
using System.Collections.Generic;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Response;
using Siger.Middlelayer.Repository.Data.Acc;
using Siger.Middlelayer.Repository.Paged;

namespace Siger.Middlelayer.AccRepository.Repositories.Interface
{
    public interface IBasketPositionRepository : IAccRepositoryBase<siger_tr_basketful_position>
    {

        IEnumerable<WrokCodeReport> GetReportsInfo(int projectId,int station=0,string workCode="");

        IEnumerable<WrokCodeReport> GetReportsInfoDtl(int projectId, int station = 0, string workCode = "");

        IEnumerable<MachineStateWorkDtl> GetMachineReportsInfoDtlBydate(int projectId,DateTime begin,DateTime end);

        IEnumerable<WrokCodeReport> GetReportsInfoDtlBydate(int projectId, DateTime begin, DateTime end, List<int> position);



        IPagedCollectionResult<BasketPositionInfo> GetBasketPositionInfoList(string code,int pid, int page, int pagesize);

        IEnumerable<ReportInfoDetail> GetReportStationDtl(int projectId, DateTime begin, DateTime end);

        IEnumerable<BasketTotal> GetReportTotalByDate(int projectId, string productBh, string productName, string productType, string orderNo, string wo, int section, DateTime begin, DateTime end);
       
    }
}
