﻿using System.Collections.Generic;
using System.Linq;
using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Common;
using Siger.Middlelayer.Repository.Data.Acc;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerPageLevelRepository : AccRepositoryBase<SigerTrPageLevel>, ISigerPageLevelRepository
    {
        private ApiAccDbContext accDbContext;
        public SigerPageLevelRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public IEnumerable<PageLevelTree> GetPageTree(int projectid, int parentid)
        {
            var sigerTrPageLevels = new List<PageLevelTree>();
            var query = GetSonLevel(projectid, parentid);
            foreach (var item in query)
            {
                sigerTrPageLevels.Add(new PageLevelTree
                {
                    id = item.id,
                    parentid = item.parentid,
                    name = item.title,
                    icon = item.icon,
                    category = item.category,
                    url = item.url,
                    content = item.content
                });
            }
            return sigerTrPageLevels;
        }

        public IEnumerable<SigerTrPageLevel> GetSonLevel(int projectid, int parentid)
        {
            var query = from t in accDbContext.siger_tr_page_level
                        where t.projectId == projectid && t.status == (int)RowState.Valid && t.parentid == parentid
                        select t;

            return query.ToList().Concat(query.ToList().SelectMany(t => GetSonLevel(projectid, t.id)));
        }

    }
}
