﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.AccRepository.Request;
using Siger.Middlelayer.Repository.Paged;
using System.Linq;
using System.Data;
using Siger.Middlelayer.Common.Extensions;
using Siger.Middlelayer.Common;
using System;
using System.Linq.Expressions;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using Siger.Middlelayer.AccRepository.Response;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerPrinterLebleFileRepository : AccRepositoryBase<SigerTrPrinterLebleFile>, ISigerPrinterLebleFile
    {
        private ApiAccDbContext accDbContext;
        public SigerPrinterLebleFileRepository(ApiAccDbContext context) : base(context)
        {
            accDbContext = context;
        }

        public IPagedCollectionResult<RequestCertificate> GetAllList(RequestPostCertificate req,int projectid)
        {
            var query = from a in accDbContext.siger_tr_sn_list
                        join b in accDbContext.siger_project_product on a.ProductId equals b.id
                        join c in accDbContext.siger_tr_printer_labelfile on a.ProductCode equals c.productid
                        join d in accDbContext.siger_project_user on c.uid equals d.mid.ToStr() into dd
                        from d in dd.DefaultIfEmpty()
                        where a.projectId == projectid && a.status == (int)RowState.Valid && b.projectid == projectid && b.status == (int)RowState.Valid
                              && c.projectId == projectid && c.status == (int)RowState.Valid && a.SN==req.SN
                        select new RequestCertificate
                        { 
                            id=c.id,
                            SN=a.SN,
                            productId=b.id,
                            product_code=b.code,
                            product_name=b.name,
                            labeltype=c.labeltype,
                            printtype=c.printtype,
                            FilePath=c.filepath,
                            FileName=c.labelfilename,
                            UID =d!=null?d.name:"",
                            TransDateTime=c.transdatetime,
                            wo=a.WO,
                            Line=a.Line,
                            spec=b.drawingcode
                        };

            Expression<Func<RequestCertificate, bool>> Funlabeltype = f => true;
            if (req.labeltype>0)
                Funlabeltype = f => f.labeltype== req.labeltype.ToStr();
            var totalCount = query.Count(Funlabeltype);
            var resultList = query.Where(Funlabeltype).OrderByDescending(o => o.id).Skip((req.page - 1) * req.pagesize)
                .Take(req.pagesize).AsNoTracking();
            return new PagedCollectionResult<RequestCertificate>(resultList, totalCount);
        }

        public IEnumerable<ResponsePrintLableFileUrl> GetFileUrl(string labletype, int printtype, string productcode, int projectid)
        {
            var query = from p in accDbContext.siger_tr_printer_labelfile
                        where p.labeltype == labletype && p.printtype == printtype && p.productid == productcode &&
                        p.projectId == projectid && p.status == (int)RowState.Valid
                        select new ResponsePrintLableFileUrl
                        {
                            file_url = p.filepath ?? "",
                            fileid=p.id,
                            filename=p.labelfilename,
                            image=p.image
                        };

            return query;
        }

        public IEnumerable<ResponsePrintFileRelation> GetLabelRelation(string labletype, int printtype, string productcode, int projectid)
        {
            var query = from p in accDbContext.siger_tr_printer_labelfile
                        join q in accDbContext.siger_tr_printer_relation on p.id equals q.fileid
                        where p.labeltype == labletype && p.printtype == printtype && p.productid == productcode &&
                        p.projectId == projectid && p.status == (int)RowState.Valid
                        select new ResponsePrintFileRelation
                        {
                            fileid = p.id.ToString(),
                            fileurl = p.filepath,
                            tablename = q.table_name,
                            tableparamter = q.table_parameters,
                            txtparamter = q.txt_parameters
                        };

            return query;
        }

        public ResponseSnLists GetSnList(string sn, int projectId)
        {
            var snList = accDbContext.siger_tr_sn_list.Where(q => q.SN == sn && q.projectId == projectId && q.status == (int)RowState.Valid).FirstOrDefault();
            if (snList!=null)
            {
                var product = accDbContext.siger_project_product.Where(q=>q.id==snList.ProductId && q.projectid == projectId && q.status == (int)RowState.Valid).FirstOrDefault();
                var productPlan = accDbContext.siger_project_product_plan.Where(q=>q.code==snList.WO && q.projectId == projectId && q.status == (int)RowState.Valid).FirstOrDefault();
                var mate = accDbContext.siger_tr_materials.Where(q => q.id == snList.MaterialId && q.projectId == projectId && q.status == (int)RowState.Valid).FirstOrDefault();
                var level = accDbContext.siger_project_level_section.Where(q => q.id == snList.Line && q.projectid == projectId && q.status == (int)RowState.Valid).FirstOrDefault();
                var list = new ResponseSnLists()
                {
                    SN = snList.SN,
                    ProductCode = product != null ? product.code : "",
                    ProductNmae = product != null ? product.name : "",
                    spec = product != null ? product.drawingcode : "",
                    Line = snList.Line,
                    title= level!=null?level.title:"",
                    WO = snList.WO,
                    install_count = productPlan!=null?productPlan.install_count:0,
                    ordernumber = productPlan != null ? productPlan.ordernumber : "",
                    quantity = productPlan != null ? productPlan.quantity.ToStr() :"0",
                    delivery_time = productPlan != null ? productPlan.delivery_time: 0,
                };
                return list;

            }
            return null;
        }
    }
}
