﻿using Siger.Middlelayer.AccRepository.Entities;
using Siger.Middlelayer.AccRepository.Repositories.Interface;
using Siger.Middlelayer.Common;
using System.Linq;

namespace Siger.Middlelayer.AccRepository.Repositories
{
    internal class SigerTrPowerSectionRepository : AccRepositoryBase<SigerTrPowerSection>, ISigerTrPowerSectionRepository
    {
        private readonly ApiAccDbContext _dbContext;
        public SigerTrPowerSectionRepository(ApiAccDbContext dbContext) : base(dbContext)
        {
            _dbContext = dbContext;
        }
        public bool CheckPowerBySection(int section, int pid, string value, PowerType type = PowerType.Web)
        {
            var power = _dbContext.siger_user_power.Where(f => f.status == (int)RowState.Valid && f.value.Equals(value) && f.type == (int)type).FirstOrDefault();
            if (power == null)
            {
                return false;
            }
            var sectionPower = _dbContext.siger_tr_power_section.Where(f => f.status == (int)RowState.Valid && f.projectId.Equals(pid) && f.MenuId.Equals(power.id) && f.StationId.Equals(section)).FirstOrDefault();
            if (sectionPower == null)
            {
                return false;
            }
            return true;
        }
    }
}
