﻿using System.ComponentModel.DataAnnotations;

namespace Siger.Middlelayer.AccRepository.Request
{
    public class RequestBlock
    {
        /// <summary>
        /// 功能类型
        /// </summary>
        [Required(ErrorMessage = "FuncTypeID是必须的")]
        public int FuncTypeID { get; set; }
        /// <summary>
        /// 功能名称
        /// </summary>
        [Required(ErrorMessage = "FuncNameID是必须的")]
        public int FuncNameID { get; set; }
        /// <summary>
        /// 零件类型
        /// </summary>
        [Required(ErrorMessage = "CombTypeID是必须的")]
        public int CombTypeID { get; set; }

        /// <summary>
        /// 工站
        /// </summary>
        [Required(ErrorMessage = "Station是必须的")]
        public int Station { get; set; }

        /// <summary>
        /// 原因
        /// </summary>
        [Required(ErrorMessage = "Reason是必须的")]
        public string Reason { get; set; }

        [Required(ErrorMessage = "SN/BoxID是必须的")]
        public string SNBoxID { get; set; }

        [Required(ErrorMessage = "UID是必须的")]
        public int UserID { get; set; }
    }
}
