﻿using System;
using System.Reflection;
using Microsoft.Extensions.DependencyInjection;
using Siger.Middlelayer.CncRepository.Repositories;
using Siger.Middlelayer.CncRepository.Repositories.Interface;
using Siger.Middlelayer.Repository;
using Siger.Middlelayer.Repository.Repositories.Interface;

namespace Siger.Middlelayer.CncRepository
{
    public class CncRepositoryFactory
    {
        private static CncRepositoryFactory _factory;

        public static CncRepositoryFactory Instance => _factory ?? (_factory = new CncRepositoryFactory());

        public void Initialization(IServiceCollection services)
        {
            RepositoryFactory.Instance.DiRepositories(services, typeof(IApiConfigRepositoryBase<>));
            DiRepositories(services, typeof(ICncRepositoryBase<>));
            services.AddDbContext<ApiCncDbContext>();
            services.AddDbContext<ApiConfigDbContext>();
            services.AddScoped(typeof(IUnitOfWork), typeof(CncUnitOfWork));
        }

        public void DiRepositories(IServiceCollection services, Type moduleType)
        {
            foreach (Type type in Assembly.Load(GetType().Assembly.GetName()).GetTypes())
            {
                if (typeof(IRepository).IsAssignableFrom(type) && type.IsClass && !type.IsAbstract)
                {
                    var interfaces = type.GetInterfaces();
                    foreach (var i in interfaces)
                    {
                        if (!i.IsGenericType && i != typeof(IRepositoryBase<>) 
                                             && i != typeof(IRepository) 
                                             && i.Name != moduleType.Name)
                        {
                            services.AddScoped(i, type);
                        }
                    }
                }
            }
        }
    }
}
