﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel.DataAnnotations;
using Siger.Middlelayer.Common.ModuleEnum;

namespace Siger.Middlelayer.CncRepository.Request
{
    public class RequestWoSearch
    {
        public string Key { get; set; }
    }

    public class RequestWoReport
    {

        /// <summary>
        /// 报工人员MID
        /// </summary>
        public int Mid { get; set; }
        /// <summary>
        /// 报工工位SectionId
        /// </summary>
        public int SectionId { get; set; }
        /// <summary>
        /// 工单
        /// </summary>
        public string Wo { get; set; }
        /// <summary>
        /// 合格数量
        /// </summary>
        public int OkCount { get; set; }
        /// <summary>
        /// 工废
        /// </summary>
        public int NgCount { get; set; }
        /// <summary>
        /// 料废
        /// </summary>
        public int NgCount2 { get; set; }
        /// <summary>
        /// 试料
        /// </summary>
        public int DebugCount { get; set; }

    }

    public class RequestInspection
    {
        /// <summary>
        /// 报工人员MID
        /// </summary>
        public int Mid { get; set; }
        /// <summary>
        /// 报工工位SectionId
        /// </summary>
        public int SectionId { get; set; }
        /// <summary>
        /// 工单
        /// </summary>
        public string Wo { get; set; }
        /// <summary>
        ///  检验类型
        /// </summary>
        public WoType Type { get; set; }
        [Required(ErrorMessage ="Items Required")]
        public List<RequestCheckItem> Items { get; set; }
    }
    public class RequestCheckItem
    {
        /// <summary>
        /// 检验项
        /// </summary>

        public string Item { get; set; }
        public string Value { get; set; }
        public string Result { get; set; }
        /// <summary>
        ///全检- 合格数量
        /// </summary>
        public int OKCount { get; set; }
        /// <summary>
        /// 全检-工废
        /// </summary>
        public int NgCount { get; set; }
        /// <summary>
        ///全检-料废
        /// </summary>
        public int NgCount2 { get; set; }
    }
   
}
